/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dev.perspective;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionElement;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionStatus;

public class RuntimeSession {
    private static final RuntimeSessionElement[] EMPTY_GROUP = new RuntimeSessionElement[0];
    private final int id;
    private final String user;
    private final Date lastupdate;
    private final RuntimeSessionStatus status;
    private final List<RuntimeSessionElement> elements = new ArrayList<RuntimeSessionElement>();
    private final Map<String, RuntimeSessionElement[]> codeGroups = new HashMap<String, RuntimeSessionElement[]>();

    public RuntimeSession(int id, String user, Date lastupdate, RuntimeSessionStatus status) {
        this.id = id;
        this.user = user;
        this.lastupdate = lastupdate;
        this.status = status;
    }

    public List<RuntimeSessionElement> getElements() {
        return this.elements;
    }

    public RuntimeSessionElement[] findElements(String code) {
        RuntimeSessionElement[] group = this.codeGroups.get(code);
        return group != null ? group : EMPTY_GROUP;
    }

    public void addElement(RuntimeSessionElement element) {
        this.elements.add(element);
        String code = element.getElementCode();
        RuntimeSessionElement[] group = this.codeGroups.get(code);
        if (group == null) {
            this.codeGroups.put(code, new RuntimeSessionElement[]{element});
        } else {
            RuntimeSessionElement[] aux = new RuntimeSessionElement[group.length + 1];
            System.arraycopy(group, 0, aux, 0, group.length);
            aux[group.length] = element;
            this.codeGroups.put(code, aux);
        }
    }

    public int getId() {
        return this.id;
    }

    public Date getLastupdate() {
        return this.lastupdate;
    }

    public RuntimeSessionStatus getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RuntimeSession[");
        sb.append("id=").append(this.id);
        sb.append(", user=").append(this.user);
        sb.append(", lu=").append(this.lastupdate);
        sb.append(", st=").append((Object)this.status);
        sb.append(']');
        return sb.toString();
    }
}

