/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao.external;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.parameter.ParameterEntry;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.external.ExternalValueSetter;
import pl.decerto.hyperon.runtime.dao.external.ResolveRequest;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.helper.MpHelper;
import pl.decerto.hyperon.runtime.model.MpLevel;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

public class ExternalStorageDao
extends BaseDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MpHelper helper = new MpHelper();
    private final DialectTemplate dialectTemplate = DialectRegistry.getDialectTemplate();
    private static final int IN_CLAUSE_MAX_SIZE = 1000;

    public ExternalStorageDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
    }

    public void resolveExternalValues(MpParameter p) {
        this.resolveExternalValues(p, p.getEntries());
    }

    public void resolveExternalValues(MpParameter p, Collection<ParameterEntry> rows) {
        this.log.trace("enter resolveExternalValues");
        long t = System.currentTimeMillis();
        for (int i = 0; i < p.getLevelCount(); ++i) {
            MpLevel level = p.getLevel(i);
            if (!level.isExternal()) continue;
            this.resolveExternalLevel(rows, i);
        }
        this.log.trace("leave resolveExternalValues, time={}", (Object)(System.currentTimeMillis() - t));
    }

    public void resolveExternalLevel(Collection<? extends ParameterEntry> rows, int levelIndex) {
        this.log.trace("resolving external values for {} rows on level: {}", (Object)rows.size(), (Object)levelIndex);
        HashMap<Integer, ResolveRequest> buffer = new HashMap<Integer, ResolveRequest>();
        for (ParameterEntry parameterEntry : rows) {
            String[] row = parameterEntry.getLevels();
            String addr = row[levelIndex];
            if (addr == null || !addr.startsWith("@")) continue;
            int externalId = Integer.parseInt(addr.substring(1));
            buffer.put(externalId, new ResolveRequest(parameterEntry, levelIndex, externalId));
            if (buffer.size() != 1000) continue;
            this.fetchExternalValues(buffer);
        }
        this.fetchExternalValues(buffer);
    }

    void fetchExternalValues(Map<Integer, ResolveRequest> buffer) {
        if (buffer.isEmpty()) {
            return;
        }
        int n = buffer.size();
        int i = 0;
        Object[] ids = new Integer[n];
        for (ResolveRequest request : buffer.values()) {
            ids[i++] = request.externalId;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select id, value");
        sb.append(" from @externalstorage");
        sb.append(" where id in (").append(this.helper.createInListPattern(n)).append(')');
        String sql = this.dialectTemplate.parse(sb.toString());
        this.log.trace("using sql: {}", (Object)sql);
        this.jdbcTemplate().query(sql, ids, new ExternalValueSetter(buffer));
        buffer.clear();
    }
}

