/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.util.List;
import javax.sql.DataSource;
import pl.decerto.hyperon.runtime.dao.MiniJdbcTemplate;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dao.util.RowMapper;

public class BaseDao {
    protected final DataSource dataSource;
    protected MiniJdbcTemplate defaultJdbcTemplate;
    protected final ConnectionInterceptor connectionInterceptor;

    protected BaseDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.dataSource = dataSource;
        this.connectionInterceptor = connectionInterceptor;
        this.defaultJdbcTemplate = new MiniJdbcTemplate(this.dataSource, this.connectionInterceptor);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultJdbcTemplate.setFetchSize(defaultFetchSize);
    }

    protected MiniJdbcTemplate jdbcTemplate() {
        return this.defaultJdbcTemplate;
    }

    public void setDefaultJdbcTemplate(MiniJdbcTemplate defaultJdbcTemplate) {
        this.defaultJdbcTemplate = defaultJdbcTemplate;
    }

    protected MiniJdbcTemplate jdbcTemplate(int fetchSize) {
        MiniJdbcTemplate jdbcTemplate = new MiniJdbcTemplate(this.dataSource, this.connectionInterceptor);
        jdbcTemplate.setFetchSize(fetchSize);
        return jdbcTemplate;
    }

    protected <T> T getOne(MiniJdbcTemplate jdbcTemplate, String sql, RowMapper<T> mapper) {
        return this.getOne(jdbcTemplate, sql, mapper, null);
    }

    protected <T> T getOne(MiniJdbcTemplate jdbcTemplate, String sql, RowMapper<T> mapper, Object ... args) {
        List<T> list;
        List<T> list2 = list = args == null ? jdbcTemplate.query(sql, mapper) : jdbcTemplate.query(sql, mapper, args);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.isEmpty()) {
            return null;
        }
        throw new RuntimeException("expected one and received: " + list.size());
    }
}

