/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.DomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCacheProvider;
import pl.decerto.hyperon.runtime.core.domain.MpDomainRefreshController;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.MpTreeDomain;

public abstract class AbstractDomainCacheManager
implements DomainCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractDomainCacheManager.class);
    protected Map<String, MpTreeDomain> headElementsByProfiles = new ConcurrentHashMap<String, MpTreeDomain>();
    protected Map<String, MpTreeDomain> sessionElementsByProfiles = new ConcurrentHashMap<String, MpTreeDomain>();
    protected final MpDomainRefreshController refreshController;
    protected final MpDomainCacheProvider cacheProvider;

    public AbstractDomainCacheManager(MpDomainCacheProvider cacheProvider, MpDomainRefreshController refreshController) {
        this.cacheProvider = cacheProvider;
        this.refreshController = refreshController;
    }

    @Override
    public Set<String> getProfiles() {
        Set<String> head = this.getProfilesFromHead();
        log.trace("getProfiles() found: {}", head);
        return new TreeSet<String>(head);
    }

    Set<String> getProfilesFromHead() {
        return this.headElementsByProfiles.keySet();
    }

    @Override
    public Set<String> getAllProfiles() {
        Set<String> all = this.getHeadAndSessionProfiles();
        log.trace("getAllProfiles() found: {}", all);
        return new TreeSet<String>(all);
    }

    Set<String> getHeadAndSessionProfiles() {
        TreeSet<String> all = new TreeSet<String>();
        for (MpTreeDomain tree : this.headElementsByProfiles.values()) {
            all.add(tree.getProfile());
        }
        for (MpTreeDomain tree : this.sessionElementsByProfiles.values()) {
            all.add(tree.getProfile());
        }
        return all;
    }

    @Override
    public HyperonDomainObject getByPath(String profileCode, String path) {
        return this.getByPath(profileCode, path, null);
    }

    @Override
    public HyperonDomainObject getByPath(String profileCode, String path, EffectiveVersionConfiguration configuration) {
        log.trace("enter getByPath({}, {}, {})", new Object[]{profileCode, path, configuration});
        boolean refreshed = false;
        if (this.headElementsByProfiles.get(profileCode) == null) {
            this.refreshController.updateTimestampsForProfile(profileCode);
            this.refreshHeadsOfProfile(profileCode, configuration);
            refreshed = true;
        }
        this.makeExtraHeadRefresh(refreshed, profileCode);
        if (this.headElementsByProfiles.get(profileCode) == null) {
            return null;
        }
        return this.headElementsByProfiles.get(profileCode).getObjectsByPath(path);
    }

    protected void makeExtraHeadRefresh(boolean refreshed, String profileCode) {
    }

    protected void refreshSessionsOfProfileAndUser(String profileCode, String user, EffectiveVersionConfiguration configuration) {
        log.trace("enter refreshSessionsOfProfileAndUser({},{},{})", new Object[]{profileCode, user, configuration});
        Map<String, MpTreeDomain> trees = this.cacheProvider.createTrees(profileCode, user, configuration);
        if (trees.isEmpty()) {
            this.clearSessions(profileCode);
            return;
        }
        for (Map.Entry<String, MpTreeDomain> tree : trees.entrySet()) {
            this.saveReloadedTree(tree);
        }
    }

    private void clearSessions(String profileCode) {
        for (Map.Entry<String, MpTreeDomain> session : this.sessionElementsByProfiles.entrySet()) {
            if (!session.getKey().endsWith("@" + profileCode)) continue;
            this.sessionElementsByProfiles.remove(session.getKey());
        }
    }

    private void saveReloadedTree(Map.Entry<String, MpTreeDomain> tree) {
        if (tree.getValue().isAnyRoot()) {
            this.sessionElementsByProfiles.put(tree.getKey(), tree.getValue());
        } else {
            this.sessionElementsByProfiles.remove(tree.getKey());
        }
    }

    protected void refreshHeadsOfProfile(String profileCode) {
        this.refreshHeadsOfProfile(profileCode, null);
    }

    protected void refreshHeadsOfProfile(String profileCode, EffectiveVersionConfiguration configuration) {
        MpTreeDomain treeDomain = this.cacheProvider.createTreeOfObjects(profileCode, configuration);
        if (treeDomain.isAnyRoot()) {
            this.headElementsByProfiles.put(profileCode, treeDomain);
        } else {
            log.debug("remove profile {}", (Object)profileCode);
            this.headElementsByProfiles.remove(profileCode);
        }
    }

    @Override
    public HyperonDomainObject getSessionElementByPath(String profileCode, String user, String path) {
        return this.getSessionElementByPath(profileCode, user, path, null);
    }

    @Override
    public void invalidateAllCaches() {
        this.headElementsByProfiles.clear();
        this.sessionElementsByProfiles.clear();
    }
}

