/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.result.FundResult;

public class SuspenseAccountResult {
    private String name;
    BigDecimal totalPaidInPremiumAmount = BigDecimal.ZERO;
    BigDecimal paidInPremiumAmount = BigDecimal.ZERO;
    BigDecimal amountToInvest = BigDecimal.ZERO;
    Map<String, FundResult> funds;
    List<CollectedCharge> charges;
    Map<String, BigDecimal> chargedAmountPerPhase;
    BigDecimal surrenderCharge;
    BigDecimal surrenderValue;

    public SuspenseAccountResult(String name) {
        this.name = name;
        this.funds = new LinkedHashMap<String, FundResult>();
        this.chargedAmountPerPhase = new LinkedHashMap<String, BigDecimal>();
        this.charges = new ArrayList<CollectedCharge>();
    }

    public String getName() {
        return this.name;
    }

    public void setTotalPaidInPremiumAmount(BigDecimal totalPaidInPremiumAmount) {
        this.totalPaidInPremiumAmount = totalPaidInPremiumAmount;
    }

    public void setPaidInPremiumAmount(BigDecimal paidInPremiumAmount) {
        this.paidInPremiumAmount = paidInPremiumAmount;
    }

    public void setAmountToInvest(BigDecimal amountToInvest) {
        this.amountToInvest = amountToInvest;
    }

    public void addFundResult(FundResult fundResult) {
        this.funds.put(fundResult.getCode(), fundResult);
    }

    public FundResult getFundResult(String code) {
        return this.funds.get(code);
    }

    public void addCollectedCharges(List<CollectedCharge> charges) {
        this.charges.addAll(charges);
    }

    public void addCollectedCharge(CollectedCharge charge) {
        this.charges.add(charge);
    }

    public Collection<FundResult> getFundResults() {
        return this.funds.values();
    }

    public Collection<CollectedCharge> getCollectedCharges() {
        return this.charges;
    }

    public BigDecimal getAmountToInvest() {
        return this.amountToInvest;
    }

    public Map<String, BigDecimal> getChargedAmountPerPhase() {
        return this.chargedAmountPerPhase;
    }

    public void setChargedAmountPerPhase(Map<String, BigDecimal> chargedAmountPerPhase) {
        this.chargedAmountPerPhase = chargedAmountPerPhase;
    }

    public BigDecimal getSurrenderCharge() {
        return this.surrenderCharge;
    }

    public void setSurrenderCharge(BigDecimal surrenderCharge) {
        this.surrenderCharge = surrenderCharge;
    }

    public BigDecimal getSurrenderValue() {
        return this.surrenderValue;
    }

    public void setSurrenderValue(BigDecimal surrenderValue) {
        this.surrenderValue = surrenderValue;
    }
}

