/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.params;

import java.util.ArrayList;
import java.util.List;
import pl.decerto.hyperon.mp.simulation.life.invest.params.FundDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PaymentDefinition;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.utils.Messages;

public class SuspenseAccountDefinition {
    private String name;
    private List<FundDefinition> fundDefinitions;
    private List<PaymentDefinition> paymentDefinitions;
    private int startingMonth = 0;

    public SuspenseAccountDefinition() {
        this("");
    }

    public SuspenseAccountDefinition(String name) {
        this.name = name;
        this.fundDefinitions = new ArrayList<FundDefinition>();
        this.paymentDefinitions = new ArrayList<PaymentDefinition>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FundDefinition> getFundDefinitions() {
        return this.fundDefinitions;
    }

    public void setFundDefinitions(List<FundDefinition> fundDefinitions) {
        this.fundDefinitions = fundDefinitions;
    }

    public void addFundDefinitions(FundDefinition fundDefinition) {
        this.fundDefinitions.add(fundDefinition);
    }

    public List<PaymentDefinition> getPaymentDefinitions() {
        return this.paymentDefinitions;
    }

    public void setPaymentDefinitions(List<PaymentDefinition> paymentDefinitions) {
        this.paymentDefinitions = paymentDefinitions;
    }

    public SuspenseAccountDefinition withFundDefinition(FundDefinition fundDefinition) {
        this.fundDefinitions.add(fundDefinition);
        return this;
    }

    public SuspenseAccountDefinition withFundDefinitions(List<FundDefinition> fundDefinitions) {
        this.fundDefinitions.clear();
        this.fundDefinitions.addAll(fundDefinitions);
        return this;
    }

    public SuspenseAccountDefinition withPaymentDefinition(PaymentDefinition paymentDefinition) {
        this.paymentDefinitions.add(paymentDefinition);
        return this;
    }

    public SuspenseAccountDefinition withPaymentDefinitions(List<PaymentDefinition> paymentDefinitions) {
        this.paymentDefinitions.clear();
        this.paymentDefinitions.addAll(paymentDefinitions);
        return this;
    }

    public void isAccountFundsProperlyDefined() {
        if (this.fundDefinitions == null || this.fundDefinitions.isEmpty()) {
            throw new HyperonRuntimeException(Messages.message("simulation.parameters.noFunds"));
        }
    }

    public void isAccountPaymentsProperlyDefined() {
        if (this.paymentDefinitions == null || this.paymentDefinitions.isEmpty()) {
            throw new HyperonRuntimeException(Messages.message("simulation.parameters.noPayments"));
        }
    }

    public int getStartingMonth() {
        return this.startingMonth;
    }

    public void setStartingMonth(int startingMonth) {
        this.startingMonth = startingMonth;
    }
}

