/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.params;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FundDefinition {
    private String code;
    private String type;
    private BigDecimal split;
    private String name;
    private Map<String, BigDecimal> yearRateReturns;

    public FundDefinition(String code, String type, BigDecimal split) {
        this.code = code;
        this.type = type;
        this.split = split;
        this.yearRateReturns = new HashMap<String, BigDecimal>();
    }

    public FundDefinition(String code, String type, BigDecimal split, String name) {
        this(code, type, split);
        this.name = name;
    }

    public FundDefinition(String type) {
        this("", type, BigDecimal.ZERO);
    }

    public FundDefinition() {
        this("", "FUND", BigDecimal.ZERO);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getSplit() {
        return this.split;
    }

    public String getType() {
        return this.type;
    }

    public void setSplit(BigDecimal split) {
        this.split = split;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addYearRateReturn(String monthFrom, BigDecimal value) {
        this.yearRateReturns.put(monthFrom, value);
    }

    public String[] getMonthsWhenRateChange() {
        ArrayList<String> months = new ArrayList<String>(this.yearRateReturns.keySet());
        Collections.sort(months, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = Integer.valueOf(o1);
                Integer i2 = Integer.valueOf(o2);
                return i1.compareTo(i2);
            }
        });
        return months.toArray(new String[months.size()]);
    }

    public BigDecimal getYearRateReturnFromMonth(String month) {
        return this.yearRateReturns.get(month);
    }
}

