/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class SimulationMpEngineProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationMpEngineProvider.class);
    private static Map<String, HyperonEngine> mpEngines = new ConcurrentHashMap<String, HyperonEngine>();

    private SimulationMpEngineProvider() {
        LOGGER.info("No instantation");
    }

    public static void registerEngineForSimulation(String simulationId, HyperonEngine mpEngine) {
        LOGGER.debug("enter registerEngineForSimulation({},{})", (Object)simulationId, (Object)mpEngine);
        mpEngines.put(simulationId, mpEngine);
    }

    public static HyperonEngine getEngineForSimulation(String simulationId) {
        LOGGER.trace("enter getEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
        return mpEngines.get(simulationId);
    }

    public static void unregisteEngineForSimulation(String simulationId) {
        LOGGER.debug("enter unregisteEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
        mpEngines.remove(simulationId);
        LOGGER.trace("leaving unregisteEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
    }
}

