/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.datetime;

import java.util.Date;
import org.smartparam.engine.core.type.AbstractValueHolder;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import org.smartparam.engine.types.datetime.DatetimeType;

public class DatetimeHolder
extends AbstractValueHolder {
    private final Date date;

    public DatetimeHolder(Date date) {
        this.date = date;
    }

    @Override
    public Date getValue() {
        return this.date;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Date getDatetime() {
        return this.date;
    }

    @Override
    public Long getLong() {
        return this.date != null ? Long.valueOf(this.date.getTime()) : null;
    }

    @Override
    public long longValue() {
        return this.date != null ? this.date.getTime() : 0L;
    }

    @Override
    public String getString() {
        return this.getString(DatetimeType.getDefaultOutputPattern());
    }

    public String getString(String pattern) {
        return this.date != null ? SimpleDateFormatPool.get(pattern).format(this.date) : null;
    }
}

