/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.decoder;

import java.util.Collection;
import org.smartparam.engine.core.decoder.TypeConversionException;
import org.smartparam.engine.core.decoder.TypeDecodingException;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;

public final class TypeDecoder {
    private TypeDecoder() {
    }

    public static ValueHolder decode(Type<?> type, String text) {
        try {
            return type.decode(text != null ? text.trim() : null);
        }
        catch (RuntimeException exception) {
            throw new TypeDecodingException(exception, text, type);
        }
    }

    public static ValueHolder convert(Type<?> type, Object obj) {
        try {
            return type.convert(obj);
        }
        catch (RuntimeException exception) {
            throw new TypeConversionException(exception, obj, type);
        }
    }

    public static ValueHolder[] convert(Type<?> type, Object[] array) {
        ValueHolder[] result = type.newArray(array.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = TypeDecoder.convert(type, array[i]);
        }
        return result;
    }

    public static ValueHolder[] convert(Type<?> type, Collection<?> coll) {
        return TypeDecoder.convert(type, coll.toArray());
    }
}

