/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.annotated.initialization;

import org.smartparam.engine.annotated.PackageList;
import org.smartparam.engine.annotated.repository.TypeScanningRepository;
import org.smartparam.engine.annotated.scanner.PackageTypeScanner;
import org.smartparam.engine.annotated.scanner.TypeScanner;
import org.smartparam.engine.config.initialization.ComponentInitializer;
import org.smartparam.engine.config.initialization.ComponentInitializerRunner;

public class TypeScannerInitializer
implements ComponentInitializer {
    private final PackageList packagesToScan;
    private final TypeScanner typeScanner;

    public TypeScannerInitializer(TypeScanner typeScanner, PackageList packageList) {
        this.typeScanner = typeScanner;
        this.packagesToScan = packageList;
    }

    public TypeScannerInitializer(PackageList packagesToScan) {
        this(new PackageTypeScanner(packagesToScan), packagesToScan);
    }

    @Override
    public void initializeObject(Object configObject, ComponentInitializerRunner runner) {
        TypeScanningRepository repository = (TypeScanningRepository)configObject;
        repository.scanAnnotations(this.typeScanner, runner);
    }

    @Override
    public boolean acceptsObject(Object configObject) {
        return TypeScanningRepository.class.isAssignableFrom(configObject.getClass());
    }

    public PackageList getPackageList() {
        return this.packagesToScan;
    }

    public String getDefaultPackage() {
        return this.packagesToScan.getDefaultPackage();
    }
}

