/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import pl.chilldev.web.core.path.PathTransformer;
import pl.chilldev.web.spring.config.HandlePageModelBeanDefinitionParser;
import pl.chilldev.web.spring.config.HandlePaginationBeanDefinitionParser;
import pl.chilldev.web.spring.config.HandleTextProcessingBeanDefinitionParser;
import pl.chilldev.web.spring.config.KeywordsBeanDefinitionParser;
import pl.chilldev.web.spring.config.LinkBeanDefinitionParser;
import pl.chilldev.web.spring.config.MetaHttpEquivBeanDefinitionParser;
import pl.chilldev.web.spring.config.MetaNameBeanDefinitionParser;
import pl.chilldev.web.spring.config.MetaPropertyBeanDefinitionParser;
import pl.chilldev.web.spring.config.PaginatorBeanDefinitionParser;
import pl.chilldev.web.spring.config.PathTransformerBeanDefinitionParser;
import pl.chilldev.web.spring.config.ScriptBeanDefinitionParser;
import pl.chilldev.web.spring.config.StylesheetBeanDefinitionParser;
import pl.chilldev.web.spring.config.TextFormatterBeanDefinitionParser;
import pl.chilldev.web.spring.config.TitleBeanDefinitionParser;
import pl.chilldev.web.spring.context.PageMetaModelFactoryBean;
import pl.chilldev.web.spring.pagination.DefaultPaginatorHandler;
import pl.chilldev.web.spring.text.FormatterFactoryBean;

public class WebNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String ELEMENT_HANDLEPAGEMODEL = "handle-page-model";
    public static final String ELEMENT_TITLE = "title";
    public static final String ELEMENT_METANAME = "meta-name";
    public static final String ELEMENT_METAHTTPEQUIV = "meta-http-equiv";
    public static final String ELEMENT_METAPROPERTY = "meta-property";
    public static final String ELEMENT_KEYWORDS = "keywords";
    public static final String ELEMENT_SCRIPT = "script";
    public static final String ELEMENT_LINK = "link";
    public static final String ELEMENT_STYLESHEET = "stylesheet";
    public static final String ELEMENT_PATHTRANSFORMER = "path-transformer";
    public static final String ELEMENT_HANDLETEXTPROCESSING = "handle-text-processing";
    public static final String ELEMENT_TEXTFORMATTER = "text-formatter";
    public static final String ELEMENT_HANDLEPAGINATION = "handle-pagination";
    public static final String ELEMENT_PAGINATOR = "paginator";
    public static final String PROPERTY_PATHTRANSFORMER = "pathTransformer";

    public void init() {
        this.initPageModelParsers();
        this.initTextProcessingParsers();
        this.initPaginationParsers();
    }

    private void initPageModelParsers() {
        GenericBeanDefinition pageMetaModelFactoryBean = new GenericBeanDefinition();
        pageMetaModelFactoryBean.setBeanClass(PageMetaModelFactoryBean.class);
        GenericBeanDefinition pathTransformerBean = new GenericBeanDefinition();
        pathTransformerBean.setBeanClass(PathTransformer.class);
        pageMetaModelFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_PATHTRANSFORMER, (Object)pathTransformerBean);
        this.registerBeanDefinitionParser(ELEMENT_HANDLEPAGEMODEL, new HandlePageModelBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean, (BeanDefinition)pathTransformerBean));
        this.registerBeanDefinitionParser(ELEMENT_TITLE, new TitleBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_METANAME, new MetaNameBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_METAHTTPEQUIV, new MetaHttpEquivBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_METAPROPERTY, new MetaPropertyBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_KEYWORDS, new KeywordsBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_SCRIPT, new ScriptBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_LINK, new LinkBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_STYLESHEET, new StylesheetBeanDefinitionParser((BeanDefinition)pageMetaModelFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_PATHTRANSFORMER, new PathTransformerBeanDefinitionParser((BeanDefinition)pathTransformerBean));
    }

    private void initTextProcessingParsers() {
        GenericBeanDefinition formatterFactoryBean = new GenericBeanDefinition();
        formatterFactoryBean.setBeanClass(FormatterFactoryBean.class);
        this.registerBeanDefinitionParser(ELEMENT_HANDLETEXTPROCESSING, new HandleTextProcessingBeanDefinitionParser((BeanDefinition)formatterFactoryBean));
        this.registerBeanDefinitionParser(ELEMENT_TEXTFORMATTER, new TextFormatterBeanDefinitionParser((BeanDefinition)formatterFactoryBean));
    }

    private void initPaginationParsers() {
        GenericBeanDefinition defaultPaginationHandlerBean = new GenericBeanDefinition();
        defaultPaginationHandlerBean.setBeanClass(DefaultPaginatorHandler.class);
        this.registerBeanDefinitionParser(ELEMENT_HANDLEPAGINATION, new HandlePaginationBeanDefinitionParser((BeanDefinition)defaultPaginationHandlerBean));
        this.registerBeanDefinitionParser(ELEMENT_PAGINATOR, new PaginatorBeanDefinitionParser((BeanDefinition)defaultPaginationHandlerBean));
    }
}

