/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TitleBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ELEMENT_PART = "part";
    public static final String ATTRIBUTE_SEPARATOR = "separator";
    public static final String PROPERTY_TITLESEPARATOR = "titleSeparator";
    public static final String PROPERTY_TITLE = "title";
    private Logger logger = LoggerFactory.getLogger(TitleBeanDefinitionParser.class);
    private List<String> parts = new ArrayList<String>();
    private MutablePropertyValues properties;

    public TitleBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        this.properties = pageMetaModelFactoryBean.getPropertyValues();
        this.properties.addPropertyValue(PROPERTY_TITLE, this.parts);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (element.hasAttribute(ATTRIBUTE_SEPARATOR)) {
            String separator = element.getAttribute(ATTRIBUTE_SEPARATOR);
            this.logger.info("Setting title separator to \"{}\".", (Object)separator);
            this.properties.addPropertyValue(PROPERTY_TITLESEPARATOR, (Object)separator);
        }
        for (Element child : DomUtils.getChildElementsByTagName((Element)element, (String)ELEMENT_PART)) {
            String part = DomUtils.getTextValue((Element)child);
            this.logger.info("Adding \"{}\" as title part.", (Object)part);
            this.parts.add(part);
        }
        return null;
    }
}

