/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TextFormatterBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String PROPERTY_FORMATTERS = "formatters";
    public static final String ELEMENT_BEAN = "bean";
    public static final String ATTRIBUTE_FORMAT = "format";
    private Logger logger = LoggerFactory.getLogger(TextFormatterBeanDefinitionParser.class);
    private ManagedMap<String, BeanDefinition> formatters = new ManagedMap();

    public TextFormatterBeanDefinitionParser(BeanDefinition formatterFactoryBean) {
        formatterFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_FORMATTERS, this.formatters);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String format = element.getAttribute(ATTRIBUTE_FORMAT);
        Element bean = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_BEAN);
        this.logger.info("Setting format handler for \"{}\".", (Object)format);
        this.formatters.put((Object)format, (Object)parserContext.getDelegate().parseBeanDefinitionElement(bean).getBeanDefinition());
        return null;
    }
}

