/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import pl.chilldev.web.spring.model.Stylesheet;
import pl.chilldev.web.spring.util.DomUtils;

public class StylesheetBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String PROPERTY_STYLESHEETS = "stylesheets";
    private Logger logger = LoggerFactory.getLogger(StylesheetBeanDefinitionParser.class);
    private ManagedList<BeanDefinition> stylesheets = new ManagedList();

    public StylesheetBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        pageMetaModelFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_STYLESHEETS, this.stylesheets);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String href = element.getAttribute("href");
        GenericBeanDefinition stylesheet = new GenericBeanDefinition();
        stylesheet.setBeanClass(Stylesheet.class);
        int i = 0;
        ConstructorArgumentValues arguments = stylesheet.getConstructorArgumentValues();
        arguments.addIndexedArgumentValue(i++, (Object)href);
        arguments.addIndexedArgumentValue(i++, (Object)DomUtils.getRealAttributeValue(element, "type"));
        arguments.addIndexedArgumentValue(i++, (Object)DomUtils.getRealAttributeValue(element, "media"));
        this.logger.info("Adding \"{}\" stylesheet.", (Object)href);
        this.stylesheets.add((Object)stylesheet);
        return null;
    }
}

