/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import pl.chilldev.web.spring.model.Script;
import pl.chilldev.web.spring.util.DomUtils;

public class ScriptBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATTRIBUTE_SRC = "src";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_FLOW = "flow";
    public static final String ATTRIBUTE_CHARSET = "charset";
    public static final String PROPERTY_SCRIPTS = "scripts";
    private Logger logger = LoggerFactory.getLogger(ScriptBeanDefinitionParser.class);
    private ManagedList<BeanDefinition> scripts = new ManagedList();

    public ScriptBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        pageMetaModelFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_SCRIPTS, this.scripts);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String src = element.getAttribute(ATTRIBUTE_SRC);
        GenericBeanDefinition script = new GenericBeanDefinition();
        script.setBeanClass(Script.class);
        int i = 0;
        ConstructorArgumentValues arguments = script.getConstructorArgumentValues();
        arguments.addIndexedArgumentValue(i++, (Object)src);
        arguments.addIndexedArgumentValue(i++, (Object)DomUtils.getRealAttributeValue(element, ATTRIBUTE_TYPE));
        arguments.addIndexedArgumentValue(i++, (Object)DomUtils.getRealAttributeValue(element, ATTRIBUTE_FLOW));
        arguments.addIndexedArgumentValue(i++, (Object)DomUtils.getRealAttributeValue(element, ATTRIBUTE_CHARSET));
        this.logger.info("Adding \"{}\" script.", (Object)src);
        this.scripts.add((Object)script);
        return null;
    }
}

