/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import pl.chilldev.web.spring.model.Link;

public class LinkBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ELEMENT_REL = "rel";
    public static final String ATTRIBUTE_HREF = "href";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_MEDIA = "media";
    public static final String PROPERTY_LINKS = "links";
    private Logger logger = LoggerFactory.getLogger(LinkBeanDefinitionParser.class);
    private ManagedList<BeanDefinition> links = new ManagedList();

    public LinkBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        pageMetaModelFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_LINKS, this.links);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String href = element.getAttribute(ATTRIBUTE_HREF);
        HashSet<String> rels = new HashSet<String>();
        for (Element child : DomUtils.getChildElementsByTagName((Element)element, (String)ELEMENT_REL)) {
            rels.add(DomUtils.getTextValue((Element)child));
        }
        GenericBeanDefinition link = new GenericBeanDefinition();
        link.setBeanClass(Link.class);
        int i = 0;
        ConstructorArgumentValues arguments = link.getConstructorArgumentValues();
        arguments.addIndexedArgumentValue(i++, (Object)href);
        arguments.addIndexedArgumentValue(i++, rels);
        arguments.addIndexedArgumentValue(i++, (Object)pl.chilldev.web.spring.util.DomUtils.getRealAttributeValue(element, ATTRIBUTE_TYPE));
        arguments.addIndexedArgumentValue(i++, (Object)pl.chilldev.web.spring.util.DomUtils.getRealAttributeValue(element, ATTRIBUTE_MEDIA));
        this.logger.info("Adding \"{}\" link.", (Object)href);
        this.links.add((Object)link);
        return null;
    }
}

