/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.chilldev.web.core.markup.Generator;
import pl.chilldev.web.core.page.PageMetaModel;
import pl.chilldev.web.core.path.PathTransformerInterface;
import pl.chilldev.web.spring.model.Link;
import pl.chilldev.web.spring.model.Script;
import pl.chilldev.web.spring.model.Stylesheet;

public class PageMetaModelFactoryBean {
    protected PathTransformerInterface pathTransformer;
    protected Map<URI, String> xmlNamespaces = new HashMap<URI, String>();
    protected List<String> title = new ArrayList<String>();
    protected String titleSeparator;
    protected Map<String, Object> metaHttpEquiv = new HashMap<String, Object>();
    protected Map<String, Object> metaNames = new HashMap<String, Object>();
    protected Map<String, Object> metaProperties = new HashMap<String, Object>();
    protected List<String> keywords = new ArrayList<String>();
    protected List<Script> scripts = new ArrayList<Script>();
    protected List<Link> links = new ArrayList<Link>();
    protected List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();

    public void setPathTransformer(PathTransformerInterface pathTransformer) {
        this.pathTransformer = pathTransformer;
    }

    public void setXmlNamespaces(Map<URI, String> xmlNamespaces) {
        this.xmlNamespaces = xmlNamespaces;
    }

    public void setTitle(List<String> title) {
        this.title = title;
    }

    public void setTitleSeparator(String titleSeparator) {
        this.titleSeparator = titleSeparator;
    }

    public void setMetaHttpEquiv(Map<String, Object> metaHttpEquiv) {
        this.metaHttpEquiv = metaHttpEquiv;
    }

    public void setMetaNames(Map<String, Object> metaNames) {
        this.metaNames = metaNames;
    }

    public void setMetaProperties(Map<String, Object> metaProperties) {
        this.metaProperties = metaProperties;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setStylesheets(List<Stylesheet> stylesheets) {
        this.stylesheets = stylesheets;
    }

    public PageMetaModel createPageMetaModel() {
        return this.initializePageMetaModel(new PageMetaModel(this.pathTransformer));
    }

    public PageMetaModel createPageMetaModel(Generator generator) {
        return this.initializePageMetaModel(new PageMetaModel(generator, this.pathTransformer));
    }

    protected PageMetaModel initializePageMetaModel(PageMetaModel page) {
        this.initializePageMetaModelXmlNamespaces(page).initializePageMetaModelTitleParts(page).initializePageMetaModelTitleSeparator(page).initializePageMetaModelHttpEquivs(page).initializePageMetaModelMetaNames(page).initializePageMetaModelMetaProperties(page).initializePageMetaModelKeywords(page).initializePageMetaModelScripts(page).initializePageMetaModelLinks(page).initializePageMetaModelStylesheets(page);
        return page;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelXmlNamespaces(PageMetaModel page) {
        this.xmlNamespaces.forEach((arg_0, arg_1) -> ((PageMetaModel)page).setXmlNamespace(arg_0, arg_1));
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelTitleParts(PageMetaModel page) {
        this.title.forEach(arg_0 -> ((PageMetaModel)page).addTitlePart(arg_0));
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelTitleSeparator(PageMetaModel page) {
        if (this.titleSeparator != null) {
            page.setTitleSeparator(this.titleSeparator);
        }
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelHttpEquivs(PageMetaModel page) {
        this.metaHttpEquiv.forEach((arg_0, arg_1) -> ((PageMetaModel)page).setHttpEquiv(arg_0, arg_1));
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelMetaNames(PageMetaModel page) {
        this.metaNames.forEach((arg_0, arg_1) -> ((PageMetaModel)page).setMetaName(arg_0, arg_1));
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelMetaProperties(PageMetaModel page) {
        this.metaProperties.forEach((arg_0, arg_1) -> ((PageMetaModel)page).setMetaProperty(arg_0, arg_1));
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelKeywords(PageMetaModel page) {
        page.addKeywords(this.keywords);
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelScripts(PageMetaModel page) {
        for (Script script : this.scripts) {
            page.addScript(script.getSrc(), script.getType(), script.getFlow(), script.getCharset());
        }
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelLinks(PageMetaModel page) {
        for (Link link : this.links) {
            page.addLink(link.getHref(), link.getRels(), link.getType(), link.getMedia());
        }
        return this;
    }

    protected PageMetaModelFactoryBean initializePageMetaModelStylesheets(PageMetaModel page) {
        for (Stylesheet stylesheet : this.stylesheets) {
            page.addStylesheet(stylesheet.getHref(), stylesheet.getType(), stylesheet.getMedia());
        }
        return this;
    }
}

