/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PathTransformerBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String PROPERTY_TRANSFORMERS = "transformers";
    public static final String ELEMENT_BEAN = "bean";
    public static final String ATTRIBUTE_PREFIX = "prefix";
    protected Logger logger = LoggerFactory.getLogger(PathTransformerBeanDefinitionParser.class);
    protected ManagedMap<String, BeanDefinition> transformers = new ManagedMap();

    public PathTransformerBeanDefinitionParser(BeanDefinition pathTransformerBean) {
        pathTransformerBean.getPropertyValues().addPropertyValue(PROPERTY_TRANSFORMERS, this.transformers);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String prefix = element.getAttribute(ATTRIBUTE_PREFIX);
        Element bean = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_BEAN);
        this.logger.info("Setting path transformer for \"@{}:\" prefix.", (Object)prefix);
        this.transformers.put((Object)prefix, (Object)parserContext.getDelegate().parseBeanDefinitionElement(bean).getBeanDefinition());
        return null;
    }
}

