/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.chilldev.web.core.markup.Generator;
import pl.chilldev.web.core.page.PageMetaModel;
import pl.chilldev.web.spring.model.Link;
import pl.chilldev.web.spring.model.Script;
import pl.chilldev.web.spring.model.Stylesheet;

public class PageMetaModelFactoryBean {
    protected Map<URI, String> xmlNamespaces = new HashMap<URI, String>();
    protected List<String> title = new ArrayList<String>();
    protected String titleSeparator;
    protected Map<String, Object> metaHttpEquiv = new HashMap<String, Object>();
    protected Map<String, Object> metaNames = new HashMap<String, Object>();
    protected Map<String, Object> metaProperties = new HashMap<String, Object>();
    protected List<String> keywords = new ArrayList<String>();
    protected List<Script> scripts = new ArrayList<Script>();
    protected List<Link> links = new ArrayList<Link>();
    protected List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();

    public void setXmlNamespaces(Map<URI, String> xmlNamespaces) {
        this.xmlNamespaces = xmlNamespaces;
    }

    public void setTitle(List<String> title) {
        this.title = title;
    }

    public void setTitleSeparator(String titleSeparator) {
        this.titleSeparator = titleSeparator;
    }

    public void setMetaHttpEquiv(Map<String, Object> metaHttpEquiv) {
        this.metaHttpEquiv = metaHttpEquiv;
    }

    public void setMetaNames(Map<String, Object> metaNames) {
        this.metaNames = metaNames;
    }

    public void setMetaProperties(Map<String, Object> metaProperties) {
        this.metaProperties = metaProperties;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setScripts(List<Script> scripts) {
        this.scripts = scripts;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setStylesheets(List<Stylesheet> stylesheets) {
        this.stylesheets = stylesheets;
    }

    public PageMetaModel createPageMetaModel() {
        return this.initializePageMetaModel(new PageMetaModel());
    }

    public PageMetaModel createPageMetaModel(Generator generator) {
        return this.initializePageMetaModel(new PageMetaModel(generator));
    }

    protected PageMetaModel initializePageMetaModel(PageMetaModel page) {
        for (Map.Entry<URI, String> entry : this.xmlNamespaces.entrySet()) {
            page.setXmlNamespace(entry.getKey(), entry.getValue());
        }
        for (String string : this.title) {
            page.addTitlePart(string);
        }
        if (this.titleSeparator != null) {
            page.setTitleSeparator(this.titleSeparator);
        }
        for (Map.Entry entry : this.metaHttpEquiv.entrySet()) {
            page.setHttpEquiv((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.metaNames.entrySet()) {
            page.setMetaName((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.metaProperties.entrySet()) {
            page.setMetaProperty((String)entry.getKey(), entry.getValue());
        }
        page.addKeywords(this.keywords);
        for (Script script : this.scripts) {
            page.addScript(script.getSrc(), script.getType(), script.getFlow(), script.getCharset());
        }
        for (Link link : this.links) {
            page.addLink(link.getHref(), link.getRels(), link.getType(), link.getMedia());
        }
        for (Stylesheet stylesheet : this.stylesheets) {
            page.addStylesheet(stylesheet.getHref(), stylesheet.getType(), stylesheet.getMedia());
        }
        return page;
    }
}

