/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.util.EntitlementUtil;

public class SyncopeUserQueryImpl
implements UserQuery {
    private UserDAO userDAO;
    private RoleDAO roleDAO;
    private EntitlementDAO entitlementDAO;
    private String username;
    private Long memberOf;
    private List<User> result;

    public SyncopeUserQueryImpl(UserDAO userDAO, RoleDAO roleDAO, EntitlementDAO entitlementDAO) {
        this.userDAO = userDAO;
        this.roleDAO = roleDAO;
        this.entitlementDAO = entitlementDAO;
    }

    public UserQuery userId(String id) {
        this.username = id;
        return this;
    }

    public UserQuery userFirstName(String firstName) {
        return this;
    }

    public UserQuery userFirstNameLike(String firstNameLike) {
        return this;
    }

    public UserQuery userLastName(String lastName) {
        return this;
    }

    public UserQuery userLastNameLike(String lastNameLike) {
        return this;
    }

    public UserQuery userEmail(String email) {
        return this;
    }

    public UserQuery userEmailLike(String emailLike) {
        return this;
    }

    public UserQuery memberOfGroup(String groupId) {
        try {
            this.memberOf = Long.valueOf(groupId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public UserQuery orderByUserId() {
        return this;
    }

    public UserQuery orderByUserFirstName() {
        return this;
    }

    public UserQuery orderByUserLastName() {
        return this;
    }

    public UserQuery orderByUserEmail() {
        return this;
    }

    public UserQuery asc() {
        return this;
    }

    public UserQuery desc() {
        return this;
    }

    private User fromSyncopeUser(SyncopeUser syncopeUser) {
        return new UserEntity(syncopeUser.getUsername());
    }

    private void execute() {
        if (this.username != null) {
            SyncopeUser user = this.userDAO.find(this.username);
            if (user != null) {
                if (this.memberOf == null || user.getRoleIds().contains(this.memberOf)) {
                    this.result = Collections.singletonList(this.fromSyncopeUser(user));
                }
            } else {
                this.result = Collections.emptyList();
            }
        }
        if (this.memberOf != null) {
            SyncopeRole role = this.roleDAO.find(this.memberOf);
            if (role != null) {
                this.result = new ArrayList<User>();
                List<Membership> memberships = this.roleDAO.findMemberships(role);
                for (Membership membership : memberships) {
                    User user = this.fromSyncopeUser(membership.getSyncopeUser());
                    if (this.result.contains(user)) continue;
                    this.result.add(user);
                }
            } else {
                this.result = Collections.emptyList();
            }
        }
        if (this.result == null) {
            this.result = new ArrayList<User>();
            for (SyncopeUser user : this.userDAO.findAll(EntitlementUtil.getRoleIds(this.entitlementDAO.findAll()))) {
                this.result.add(this.fromSyncopeUser(user));
            }
        }
    }

    public long count() {
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    public User singleResult() {
        if (this.result == null) {
            this.execute();
        }
        if (this.result.isEmpty()) {
            throw new ActivitiException("Empty result");
        }
        return this.result.get(0);
    }

    public List<User> list() {
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }

    public List<User> listPage(int firstResult, int maxResults) {
        throw new UnsupportedOperationException();
    }
}

