/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.dao.RoleDAO;

public class SyncopeGroupQueryImpl
implements GroupQuery {
    private RoleDAO roleDAO;
    private Long roleId;
    private List<Group> result;

    public SyncopeGroupQueryImpl(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public GroupQuery groupId(String groupId) {
        try {
            this.roleId = Long.valueOf(groupId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public GroupQuery groupName(String groupName) {
        return this;
    }

    public GroupQuery groupNameLike(String groupNameLike) {
        return this;
    }

    public GroupQuery groupType(String groupType) {
        return this;
    }

    public GroupQuery groupMember(String groupMemberUserId) {
        return this;
    }

    public GroupQuery orderByGroupId() {
        return this;
    }

    public GroupQuery orderByGroupName() {
        return this;
    }

    public GroupQuery orderByGroupType() {
        return this;
    }

    public GroupQuery asc() {
        return this;
    }

    public GroupQuery desc() {
        return this;
    }

    private Group fromSyncopeRole(SyncopeRole role) {
        return new GroupEntity(role.getId().toString());
    }

    private void execute() {
        if (this.roleId != null) {
            SyncopeRole role = this.roleDAO.find(this.roleId);
            this.result = role != null ? Collections.singletonList(this.fromSyncopeRole(role)) : Collections.emptyList();
        }
        if (this.result == null) {
            this.result = new ArrayList<Group>();
            for (SyncopeRole role : this.roleDAO.findAll()) {
                this.result.add(this.fromSyncopeRole(role));
            }
        }
    }

    public long count() {
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    public Group singleResult() {
        if (this.result == null) {
            this.execute();
        }
        if (this.result.isEmpty()) {
            throw new ActivitiException("Empty result");
        }
        return this.result.get(0);
    }

    public List<Group> list() {
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }

    public List<Group> listPage(int firstResult, int maxResults) {
        throw new UnsupportedOperationException();
    }
}

