/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javassist.NotFoundException;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.to.WorkflowDefinitionTO;
import org.apache.syncope.client.to.WorkflowFormTO;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.workflow.AbstractUserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowException;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.PropagationOperation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class NoOpUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    private static final List<String> TASKS = Arrays.asList("create", "activate", "update", "suspend", "reactivate", "delete");
    public static final String ENABLED = "enabled";

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck) throws WorkflowException {
        return this.create(userTO, disablePwdPolicyCheck, null);
    }

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled) throws WorkflowException {
        boolean propagate_enable;
        String status;
        SyncopeUser user = new SyncopeUser();
        this.dataBinder.create(user, userTO);
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        if (enabled == null) {
            status = "created";
            propagate_enable = true;
        } else {
            status = enabled != false ? "active" : "suspended";
            propagate_enable = enabled;
        }
        user.setStatus(status);
        user = this.userDAO.save(user);
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(PropagationOperation.CREATE, user.getResourceNames());
        return new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)user.getId(), (Object)propagate_enable), propByRes, "create");
    }

    @Override
    protected WorkflowResult<Long> doActivate(SyncopeUser user, String token) throws WorkflowException {
        if (!user.checkToken(token)) {
            throw new WorkflowException(new RuntimeException("Wrong token: " + token));
        }
        user.removeToken();
        user.setStatus("active");
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, "activate");
    }

    @Override
    protected WorkflowResult<Map.Entry<Long, Boolean>> doUpdate(SyncopeUser user, UserMod userMod) throws WorkflowException {
        PropagationByResource propByRes = this.dataBinder.update(user, userMod);
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getId(), (Object)true), propByRes, "update");
    }

    @Override
    protected WorkflowResult<Long> doSuspend(SyncopeUser user) throws WorkflowException {
        user.setStatus("suspended");
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, "suspend");
    }

    @Override
    protected WorkflowResult<Long> doReactivate(SyncopeUser user) throws WorkflowException {
        user.setStatus("active");
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, "reactivate");
    }

    @Override
    protected void doDelete(SyncopeUser user) throws WorkflowException {
        this.userDAO.delete(user);
    }

    @Override
    public WorkflowResult<Long> execute(UserTO userTO, String taskId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        throw new WorkflowException(new UnsupportedOperationException("Not supported."));
    }

    @Override
    public WorkflowDefinitionTO getDefinition() throws WorkflowException {
        return new WorkflowDefinitionTO();
    }

    @Override
    public void updateDefinition(WorkflowDefinitionTO definition) throws NotFoundException, WorkflowException {
        throw new WorkflowException(new UnsupportedOperationException("Not supported."));
    }

    @Override
    public List<String> getDefinedTasks() throws WorkflowException {
        return TASKS;
    }

    @Override
    public List<WorkflowFormTO> getForms() {
        return Collections.emptyList();
    }

    @Override
    public WorkflowFormTO getForm(String workflowId) throws NotFoundException, WorkflowException {
        return null;
    }

    @Override
    public WorkflowFormTO claimForm(String taskId, String username) throws NotFoundException, WorkflowException {
        throw new WorkflowException(new UnsupportedOperationException("Not supported."));
    }

    @Override
    public WorkflowResult<Map.Entry<Long, String>> submitForm(WorkflowFormTO form, String username) throws NotFoundException, WorkflowException {
        throw new WorkflowException(new UnsupportedOperationException("Not supported."));
    }
}

