/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.FormType;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.to.WorkflowDefinitionTO;
import org.apache.syncope.client.to.WorkflowFormPropertyTO;
import org.apache.syncope.client.to.WorkflowFormTO;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.workflow.AbstractUserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowException;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.PropagationOperation;
import org.apache.syncope.types.WorkflowFormPropertyType;
import org.identityconnectors.common.security.EncryptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ActivitiUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiUserWorkflowAdapter.class);
    private static final String[] PROPERTY_IGNORE_PROPS = new String[]{"type"};
    public static final String WF_PROCESS_ID = "userWorkflow";
    public static final String WF_PROCESS_RESOURCE = "userWorkflow.bpmn20.xml";
    public static final String SYNCOPE_USER = "syncopeUser";
    public static final String USER_TO = "userTO";
    public static final String ENABLED = "enabled";
    public static final String USER_MOD = "userMod";
    public static final String EMAIL_KIND = "emailKind";
    public static final String TASK = "task";
    public static final String TOKEN = "token";
    public static final String PROP_BY_RESOURCE = "propByResource";
    public static final String PROPAGATE_ENABLE = "propagateEnable";
    public static final String ENCRYPTED_PWD = "encryptedPwd";
    @Resource(name="adminUser")
    private String adminUser;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FormService formService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;

    private void updateStatus(SyncopeUser user) {
        List tasks = this.taskService.createTaskQuery().processInstanceId(user.getWorkflowId()).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.warn("While setting user status: unexpected task number ({})", (Object)tasks.size());
        } else {
            user.setStatus(((Task)tasks.get(0)).getTaskDefinitionKey());
        }
    }

    private boolean waitingForForm(SyncopeUser user) {
        boolean result = false;
        List tasks = this.taskService.createTaskQuery().processInstanceId(user.getWorkflowId()).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.warn("While checking if form task: unexpected task number ({})", (Object)tasks.size());
        } else {
            try {
                TaskFormData formData = this.formService.getTaskFormData(((Task)tasks.get(0)).getId());
                result = formData != null && !formData.getFormProperties().isEmpty();
            }
            catch (ActivitiException e) {
                LOG.warn("Could not get task form data", (Throwable)e);
            }
        }
        return result;
    }

    private Set<String> getPerformedTasks(SyncopeUser user) {
        HashSet<String> result = new HashSet<String>();
        List tasks = this.historyService.createHistoricActivityInstanceQuery().executionId(user.getWorkflowId()).list();
        for (HistoricActivityInstance task : tasks) {
            result.add(task.getActivityId());
        }
        return result;
    }

    private String encrypt(String clear) {
        byte[] encryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(clear.getBytes());
        return new String(Base64.encode((byte[])encryptedBytes));
    }

    private String decrypt(String crypted) {
        byte[] decryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().decrypt(Base64.decode((byte[])crypted.getBytes()));
        return new String(decryptedBytes);
    }

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck) throws WorkflowException {
        return this.create(userTO, disablePwdPolicyCheck, null);
    }

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled) throws WorkflowException {
        ProcessInstance processInstance;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(USER_TO, userTO);
        variables.put(ENABLED, enabled);
        try {
            processInstance = this.runtimeService.startProcessInstanceByKey(WF_PROCESS_ID, variables);
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        SyncopeUser user = (SyncopeUser)this.runtimeService.getVariable(processInstance.getProcessInstanceId(), SYNCOPE_USER);
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        this.updateStatus(user);
        user = this.userDAO.save(user);
        Boolean propagateEnable = (Boolean)this.runtimeService.getVariable(processInstance.getProcessInstanceId(), PROPAGATE_ENABLE);
        if (propagateEnable == null) {
            propagateEnable = enabled;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(PropagationOperation.CREATE, user.getResourceNames());
        if (this.waitingForForm(user)) {
            this.runtimeService.setVariable(processInstance.getProcessInstanceId(), PROP_BY_RESOURCE, (Object)propByRes);
            propByRes = null;
            if (StringUtils.isNotBlank((String)userTO.getPassword())) {
                this.runtimeService.setVariable(processInstance.getProcessInstanceId(), ENCRYPTED_PWD, (Object)this.encrypt(userTO.getPassword()));
            }
        }
        return new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)user.getId(), (Object)propagateEnable), propByRes, this.getPerformedTasks(user));
    }

    private Set<String> doExecuteTask(SyncopeUser user, String task, Map<String, Object> moreVariables) throws WorkflowException {
        Set<String> preTasks = this.getPerformedTasks(user);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(SYNCOPE_USER, user);
        variables.put(TASK, task);
        if (moreVariables != null && !moreVariables.isEmpty()) {
            variables.putAll(moreVariables);
        }
        if (StringUtils.isBlank((String)user.getWorkflowId())) {
            throw new WorkflowException(new NotFoundException("Empty workflow id"));
        }
        List tasks = this.taskService.createTaskQuery().processInstanceId(user.getWorkflowId()).list();
        if (tasks.size() != 1) {
            LOG.warn("Expected a single task, found {}", (Object)tasks.size());
        } else {
            try {
                this.taskService.complete(((Task)tasks.get(0)).getId(), variables);
            }
            catch (ActivitiException e) {
                throw new WorkflowException(e);
            }
        }
        Set<String> postTasks = this.getPerformedTasks(user);
        postTasks.removeAll(preTasks);
        postTasks.add(task);
        return postTasks;
    }

    @Override
    protected WorkflowResult<Long> doActivate(SyncopeUser user, String token) throws WorkflowException {
        Set<String> performedTasks = this.doExecuteTask(user, "activate", Collections.singletonMap(TOKEN, token));
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, performedTasks);
    }

    @Override
    protected WorkflowResult<Map.Entry<Long, Boolean>> doUpdate(SyncopeUser user, UserMod userMod) throws WorkflowException {
        Set<String> task = this.doExecuteTask(user, "update", Collections.singletonMap(USER_MOD, userMod));
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        PropagationByResource propByRes = (PropagationByResource)this.runtimeService.getVariable(user.getWorkflowId(), PROP_BY_RESOURCE);
        if (this.waitingForForm(user) && StringUtils.isNotBlank((String)userMod.getPassword())) {
            this.runtimeService.setVariable(user.getWorkflowId(), ENCRYPTED_PWD, (Object)this.encrypt(userMod.getPassword()));
        }
        Boolean propagateEnable = (Boolean)this.runtimeService.getVariable(user.getWorkflowId(), PROPAGATE_ENABLE);
        return new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getId(), (Object)propagateEnable), propByRes, task);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    protected WorkflowResult<Long> doSuspend(SyncopeUser user) throws WorkflowException {
        Set<String> performedTasks = this.doExecuteTask(user, "suspend", null);
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, performedTasks);
    }

    @Override
    protected WorkflowResult<Long> doReactivate(SyncopeUser user) throws WorkflowException {
        Set<String> performedTasks = this.doExecuteTask(user, "reactivate", null);
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, performedTasks);
    }

    @Override
    protected void doDelete(SyncopeUser user) throws WorkflowException {
        this.doExecuteTask(user, "delete", null);
        this.userDAO.delete(user);
    }

    @Override
    public WorkflowResult<Long> execute(UserTO userTO, String taskId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        SyncopeUser user = this.dataBinder.getUserFromId(userTO.getId());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(USER_TO, userTO);
        Set<String> performedTasks = this.doExecuteTask(user, taskId, variables);
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        return new WorkflowResult<Long>(updated.getId(), null, performedTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowDefinitionTO getDefinition() throws WorkflowException {
        ProcessDefinition procDef;
        try {
            procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(WF_PROCESS_ID).latestVersion().singleResult();
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        InputStream procDefIS = this.repositoryService.getResourceAsStream(procDef.getDeploymentId(), WF_PROCESS_RESOURCE);
        Reader reader = null;
        StringWriter writer = new StringWriter();
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader(procDefIS));
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            LOG.error("While reading workflow definition {}", (Object)procDef.getKey(), (Object)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (procDefIS != null) {
                    procDefIS.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("While closing input stream for {}", (Object)procDef.getKey(), (Object)ioe);
            }
        }
        WorkflowDefinitionTO definitionTO = new WorkflowDefinitionTO();
        definitionTO.setId(WF_PROCESS_ID);
        definitionTO.setXmlDefinition(((Object)writer).toString());
        return definitionTO;
    }

    @Override
    public void updateDefinition(WorkflowDefinitionTO definition) throws NotFoundException, WorkflowException {
        if (!WF_PROCESS_ID.equals(definition.getId())) {
            throw new NotFoundException("Workflow process id " + definition.getId());
        }
        try {
            this.repositoryService.createDeployment().addInputStream(WF_PROCESS_RESOURCE, (InputStream)new ByteArrayInputStream(definition.getXmlDefinition().getBytes())).deploy();
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
    }

    @Override
    public List<String> getDefinedTasks() throws WorkflowException {
        ProcessDefinition procDef;
        ArrayList<String> result = new ArrayList<String>();
        try {
            procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(WF_PROCESS_ID).latestVersion().singleResult();
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        InputStream procDefIS = this.repositoryService.getResourceAsStream(procDef.getDeploymentId(), WF_PROCESS_RESOURCE);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(procDefIS);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xpath.evaluate("//userTask | //serviceTask | //scriptTask", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i).getAttributes().getNamedItem("id").getNodeValue());
            }
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
        finally {
            try {
                procDefIS.close();
            }
            catch (IOException ioe) {
                LOG.error("While closing input stream for {}", (Object)procDef.getKey(), (Object)ioe);
            }
        }
        return result;
    }

    private WorkflowFormPropertyType fromActivitiFormType(FormType activitiFormType) {
        WorkflowFormPropertyType result = WorkflowFormPropertyType.String;
        if ("string".equals(activitiFormType.getName())) {
            result = WorkflowFormPropertyType.String;
        }
        if ("long".equals(activitiFormType.getName())) {
            result = WorkflowFormPropertyType.Long;
        }
        if ("enum".equals(activitiFormType.getName())) {
            result = WorkflowFormPropertyType.Enum;
        }
        if ("date".equals(activitiFormType.getName())) {
            result = WorkflowFormPropertyType.Date;
        }
        if ("boolean".equals(activitiFormType.getName())) {
            result = WorkflowFormPropertyType.Boolean;
        }
        return result;
    }

    private WorkflowFormTO getFormTO(Task task, TaskFormData formData) {
        WorkflowFormTO formTO = new WorkflowFormTO();
        formTO.setTaskId(task.getId());
        formTO.setKey(formData.getFormKey());
        BeanUtils.copyProperties((Object)task, (Object)formTO);
        for (FormProperty fProp : formData.getFormProperties()) {
            WorkflowFormPropertyTO propertyTO = new WorkflowFormPropertyTO();
            BeanUtils.copyProperties((Object)fProp, (Object)propertyTO, (String[])PROPERTY_IGNORE_PROPS);
            propertyTO.setType(this.fromActivitiFormType(fProp.getType()));
            if (propertyTO.getType() == WorkflowFormPropertyType.Date) {
                propertyTO.setDatePattern((String)fProp.getType().getInformation("datePattern"));
            }
            if (propertyTO.getType() == WorkflowFormPropertyType.Enum) {
                propertyTO.setEnumValues((Map)fProp.getType().getInformation("values"));
            }
            formTO.addProperty(propertyTO);
        }
        return formTO;
    }

    @Override
    public List<WorkflowFormTO> getForms() {
        ArrayList<WorkflowFormTO> forms = new ArrayList<WorkflowFormTO>();
        for (Task task : this.taskService.createTaskQuery().list()) {
            TaskFormData formData;
            try {
                formData = this.formService.getTaskFormData(task.getId());
            }
            catch (ActivitiException e) {
                LOG.debug("No form found for task {}", (Object)task.getId(), (Object)e);
                formData = null;
            }
            if (formData == null || formData.getFormProperties().isEmpty()) continue;
            forms.add(this.getFormTO(task, formData));
        }
        return forms;
    }

    @Override
    public WorkflowFormTO getForm(String workflowId) throws NotFoundException, WorkflowException {
        TaskFormData formData;
        Task task;
        try {
            task = (Task)this.taskService.createTaskQuery().processInstanceId(workflowId).singleResult();
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        try {
            formData = this.formService.getTaskFormData(task.getId());
        }
        catch (ActivitiException e) {
            LOG.debug("No form found for task {}", (Object)task.getId(), (Object)e);
            formData = null;
        }
        WorkflowFormTO result = null;
        if (formData != null && !formData.getFormProperties().isEmpty()) {
            result = this.getFormTO(task, formData);
        }
        return result;
    }

    private Map.Entry<Task, TaskFormData> checkTask(String taskId, String username) throws NotFoundException {
        SyncopeUser user;
        TaskFormData formData;
        Task task;
        try {
            task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        }
        catch (ActivitiException e) {
            throw new NotFoundException("Activiti Task " + taskId, (Exception)((Object)e));
        }
        try {
            formData = this.formService.getTaskFormData(task.getId());
        }
        catch (ActivitiException e) {
            throw new NotFoundException("Form for Activiti Task " + taskId, (Exception)((Object)e));
        }
        if (!this.adminUser.equals(username) && (user = this.userDAO.find(username)) == null) {
            throw new NotFoundException("Syncope User " + username);
        }
        return new DefaultMapEntry((Object)task, (Object)formData);
    }

    @Override
    public WorkflowFormTO claimForm(String taskId, String username) throws NotFoundException, WorkflowException {
        Task task;
        List tasksForUser;
        Map.Entry<Task, TaskFormData> checked = this.checkTask(taskId, username);
        if (!this.adminUser.equals(username) && (tasksForUser = this.taskService.createTaskQuery().taskId(taskId).taskCandidateUser(username).list()).isEmpty()) {
            throw new WorkflowException(new RuntimeException(username + " is not candidate for task " + taskId));
        }
        try {
            this.taskService.setOwner(taskId, username);
            task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        return this.getFormTO(task, checked.getValue());
    }

    @Override
    public WorkflowResult<Map.Entry<Long, String>> submitForm(WorkflowFormTO form, String username) throws NotFoundException, WorkflowException {
        Map.Entry<Task, TaskFormData> checked = this.checkTask(form.getTaskId(), username);
        if (!checked.getKey().getOwner().equals(username)) {
            throw new WorkflowException(new RuntimeException("Task " + form.getTaskId() + " assigned to " + checked.getKey().getOwner() + " but submited by " + username));
        }
        SyncopeUser user = this.userDAO.findByWorkflowId(checked.getKey().getProcessInstanceId());
        if (user == null) {
            throw new NotFoundException("User with workflow id " + checked.getKey().getProcessInstanceId());
        }
        Set<String> preTasks = this.getPerformedTasks(user);
        try {
            this.formService.submitTaskFormData(form.getTaskId(), form.getPropertiesForSubmit());
        }
        catch (ActivitiException e) {
            throw new WorkflowException(e);
        }
        Set<String> postTasks = this.getPerformedTasks(user);
        postTasks.removeAll(preTasks);
        postTasks.add(form.getTaskId());
        this.updateStatus(user);
        SyncopeUser updated = this.userDAO.save(user);
        PropagationByResource propByRes = (PropagationByResource)this.runtimeService.getVariable(user.getWorkflowId(), PROP_BY_RESOURCE);
        String clearPassword = null;
        String encryptedPwd = (String)this.runtimeService.getVariable(user.getWorkflowId(), ENCRYPTED_PWD);
        if (StringUtils.isNotBlank((String)encryptedPwd)) {
            clearPassword = this.decrypt(encryptedPwd);
        }
        return new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getId(), (Object)clearPassword), propByRes, postTasks);
    }
}

