/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow;

import java.util.Map;
import javassist.NotFoundException;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.workflow.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowException;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractUserWorkflowAdapter
implements UserWorkflowAdapter {
    @Autowired
    protected UserDataBinder dataBinder;
    @Autowired
    protected UserDAO userDAO;

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> create(UserTO userTO) throws UnauthorizedRoleException, WorkflowException {
        return this.create(userTO, false);
    }

    protected abstract WorkflowResult<Long> doActivate(SyncopeUser var1, String var2) throws WorkflowException;

    @Override
    public WorkflowResult<Long> activate(Long userId, String token) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        return this.doActivate(this.dataBinder.getUserFromId(userId), token);
    }

    protected abstract WorkflowResult<Map.Entry<Long, Boolean>> doUpdate(SyncopeUser var1, UserMod var2) throws WorkflowException;

    @Override
    public WorkflowResult<Map.Entry<Long, Boolean>> update(UserMod userMod) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        return this.doUpdate(this.dataBinder.getUserFromId(userMod.getId()), userMod);
    }

    protected abstract WorkflowResult<Long> doSuspend(SyncopeUser var1) throws WorkflowException;

    @Override
    public WorkflowResult<Long> suspend(Long userId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        return this.suspend(this.dataBinder.getUserFromId(userId));
    }

    @Override
    public WorkflowResult<Long> suspend(SyncopeUser user) throws UnauthorizedRoleException, WorkflowException {
        user.setSuspended(Boolean.TRUE);
        return this.doSuspend(user);
    }

    protected abstract WorkflowResult<Long> doReactivate(SyncopeUser var1) throws WorkflowException;

    @Override
    public WorkflowResult<Long> reactivate(Long userId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        SyncopeUser user = this.dataBinder.getUserFromId(userId);
        user.setFailedLogins(0);
        user.setSuspended(Boolean.FALSE);
        return this.doReactivate(user);
    }

    protected abstract void doDelete(SyncopeUser var1) throws WorkflowException;

    @Override
    public void delete(Long userId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        this.doDelete(this.dataBinder.getUserFromId(userId));
    }
}

