/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util.multiparent;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MultiParentNode<T> {
    private final T object;
    private Set<MultiParentNode<T>> children;
    private int level = 0;
    private boolean exploited = false;

    public MultiParentNode(T object) {
        this.object = object;
        this.children = new HashSet<MultiParentNode<T>>();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    boolean isExploited() {
        return this.exploited;
    }

    void setExploited(boolean exploited) {
        this.exploited = exploited;
    }

    public T getObject() {
        return this.object;
    }

    public boolean isParent(MultiParentNode<T> child) {
        return this.children.contains(child);
    }

    public boolean isChild(MultiParentNode<T> parent) {
        return parent.isParent(this);
    }

    public Set<MultiParentNode<T>> getChildren() {
        return this.children;
    }

    public void addParent(MultiParentNode<T> parent) {
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public void removeParent(MultiParentNode<T> parent) {
        if (parent != null) {
            parent.children.remove(this);
        }
    }

    public void addChild(MultiParentNode<T> child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public void removeChild(MultiParentNode<T> child) {
        if (child != null) {
            this.children.remove(child);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

