/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import org.apache.syncope.client.to.NotificationTaskTO;
import org.apache.syncope.client.to.PropagationTaskTO;
import org.apache.syncope.client.to.SchedTaskTO;
import org.apache.syncope.client.to.SyncTaskTO;
import org.apache.syncope.client.to.TaskTO;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;

public enum TaskUtil {
    PROPAGATION,
    SCHED,
    SYNC,
    NOTIFICATION;


    public <T extends Task> Class<T> taskClass() {
        Class result = null;
        switch (this) {
            case PROPAGATION: {
                result = PropagationTask.class;
                break;
            }
            case SCHED: {
                result = SchedTask.class;
                break;
            }
            case SYNC: {
                result = SyncTask.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTask.class;
            }
        }
        return result;
    }

    public <T extends Task> T newTask() {
        Task result = null;
        switch (this) {
            case PROPAGATION: {
                result = new PropagationTask();
                break;
            }
            case SCHED: {
                result = new SchedTask();
                break;
            }
            case SYNC: {
                result = new SyncTask();
                break;
            }
            case NOTIFICATION: {
                result = new NotificationTask();
            }
        }
        return (T)result;
    }

    public <T extends TaskTO> Class<T> taskTOClass() {
        Class<PropagationTaskTO> result = null;
        switch (this) {
            case PROPAGATION: {
                result = PropagationTaskTO.class;
                break;
            }
            case SCHED: {
                result = SchedTaskTO.class;
                break;
            }
            case SYNC: {
                result = SyncTaskTO.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTaskTO.class;
            }
        }
        return result;
    }

    public <T extends TaskTO> T newTaskTO() {
        PropagationTaskTO result = null;
        switch (this) {
            case PROPAGATION: {
                result = new PropagationTaskTO();
                break;
            }
            case SCHED: {
                result = new SchedTaskTO();
                break;
            }
            case SYNC: {
                result = new SyncTaskTO();
                break;
            }
            case NOTIFICATION: {
                result = new NotificationTaskTO();
            }
        }
        return (T)result;
    }
}

