/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.io.IOException;
import javax.persistence.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

public class SpringPersistenceUnitPostProcessor
implements PersistenceUnitPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SpringPersistenceUnitPostProcessor.class);
    @Autowired
    private ResourcePatternResolver resResolver;
    private String[] locations;

    public void setLocations(String[] locations) {
        this.locations = locations == null ? new String[]{} : (String[])locations.clone();
    }

    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo mpui) {
        if (this.locations.length == 0) {
            LOG.warn("No locations provided");
        }
        CachingMetadataReaderFactory cachingMetadataReaderFactory = new CachingMetadataReaderFactory();
        try {
            for (String location : this.locations) {
                for (Resource resource : this.resResolver.getResources(location)) {
                    MetadataReader metadataReader = cachingMetadataReaderFactory.getMetadataReader(resource);
                    if (!metadataReader.getAnnotationMetadata().isAnnotated(Entity.class.getName())) continue;
                    mpui.addManagedClassName(metadataReader.getClassMetadata().getClassName());
                }
            }
            mpui.setExcludeUnlistedClasses(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

