/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.membership.MDerSchema;
import org.apache.syncope.core.persistence.beans.membership.MSchema;
import org.apache.syncope.core.persistence.beans.membership.MVirSchema;
import org.apache.syncope.core.persistence.beans.role.RDerSchema;
import org.apache.syncope.core.persistence.beans.role.RSchema;
import org.apache.syncope.core.persistence.beans.role.RVirSchema;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.beans.user.UAttrValue;
import org.apache.syncope.core.persistence.beans.user.UDerSchema;
import org.apache.syncope.core.persistence.beans.user.USchema;
import org.apache.syncope.core.persistence.beans.user.UVirSchema;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.types.IntMappingType;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaMappingUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(SchemaMappingUtil.class);

    public static String getExtAttrName(SchemaMapping mapping) {
        String name = mapping.isAccountid() ? Uid.NAME : (mapping.isPassword() ? OperationalAttributes.PASSWORD_NAME : mapping.getExtAttrName());
        return name;
    }

    public static String getIntAttrName(SchemaMapping mapping) {
        String name;
        switch (mapping.getIntMappingType()) {
            case SyncopeUserId: {
                name = "id";
                break;
            }
            case Username: {
                name = "username";
                break;
            }
            case Password: {
                name = "password";
                break;
            }
            default: {
                name = mapping.getIntAttrName();
            }
        }
        return name;
    }

    public static Set<SchemaMapping> getMappings(Collection<SchemaMapping> mappings, String intAttrName, IntMappingType type) {
        HashSet<SchemaMapping> result = new HashSet<SchemaMapping>();
        for (SchemaMapping schemaMapping : mappings) {
            if (schemaMapping.getIntMappingType() != type || !intAttrName.equals(SchemaMappingUtil.getIntAttrName(schemaMapping))) continue;
            result.add(schemaMapping);
        }
        return result;
    }

    public static Set<SchemaMapping> getMappings(Collection<SchemaMapping> mappings, String intAttrName) {
        HashSet<SchemaMapping> result = new HashSet<SchemaMapping>();
        for (SchemaMapping schemaMapping : mappings) {
            if (!intAttrName.equals(SchemaMappingUtil.getIntAttrName(schemaMapping))) continue;
            result.add(schemaMapping);
        }
        return result;
    }

    public static String getIntAttrName(SchemaMapping mapping, IntMappingType type) {
        return type == mapping.getIntMappingType() ? SchemaMappingUtil.getIntAttrName(mapping) : null;
    }

    public static Map.Entry<AbstractSchema, List<AbstractAttrValue>> getIntValues(SchemaMapping mapping, List<AbstractAttributable> attributables, String password, SchemaDAO schemaDAO) {
        LOG.debug("Get attributes for '{}' and mapping type '{}'", attributables, (Object)mapping.getIntMappingType());
        AbstractSchema schema = null;
        ArrayList<Object> values = new ArrayList<Object>();
        switch (mapping.getIntMappingType()) {
            case UserSchema: 
            case RoleSchema: 
            case MembershipSchema: {
                schema = (AbstractSchema)schemaDAO.find(mapping.getIntAttrName(), SchemaMappingUtil.getIntMappingTypeClass(mapping.getIntMappingType()));
                for (AbstractAttributable attributable : attributables) {
                    Object attr = attributable.getAttribute(mapping.getIntAttrName());
                    if (attr != null && ((AbstractAttr)attr).getValues() != null) {
                        values.addAll(schema.isUniqueConstraint() ? Collections.singletonList(((AbstractAttr)attr).getUniqueValue()) : ((AbstractAttr)attr).getValues());
                    }
                    LOG.debug("Retrieved attribute {}\n* IntAttrName {}\n* IntMappingType {}\n* Attribute values {}", new Object[]{attr, mapping.getIntAttrName(), mapping.getIntMappingType(), values});
                }
                break;
            }
            case UserVirtualSchema: 
            case RoleVirtualSchema: 
            case MembershipVirtualSchema: {
                for (AbstractAttributable attributable : attributables) {
                    Object virAttr = attributable.getVirtualAttribute(mapping.getIntAttrName());
                    if (virAttr != null && ((AbstractVirAttr)virAttr).getValues() != null) {
                        for (String value : ((AbstractVirAttr)virAttr).getValues()) {
                            UAttrValue attrValue = new UAttrValue();
                            attrValue.setStringValue(value);
                            values.add(attrValue);
                        }
                    }
                    LOG.debug("Retrieved virtual attribute {}\n* IntAttrName {}\n* IntMappingType {}\n* Attribute values {}", new Object[]{virAttr, mapping.getIntAttrName(), mapping.getIntMappingType(), values});
                }
                break;
            }
            case UserDerivedSchema: 
            case RoleDerivedSchema: 
            case MembershipDerivedSchema: {
                for (AbstractAttributable attributable : attributables) {
                    Object derAttr = attributable.getDerivedAttribute(mapping.getIntAttrName());
                    if (derAttr != null) {
                        UAttrValue attrValue = new UAttrValue();
                        attrValue.setStringValue(((AbstractDerAttr)derAttr).getValue(attributable.getAttributes()));
                        values.add(attrValue);
                    }
                    LOG.debug("Retrieved attribute {}\n* IntAttrName {}\n* IntMappingType {}\n* Attribute values {}", new Object[]{derAttr, mapping.getIntAttrName(), mapping.getIntMappingType(), values});
                }
                break;
            }
            case Username: {
                for (AbstractAttributable attributable : attributables) {
                    UAttrValue attrValue = new UAttrValue();
                    attrValue.setStringValue(((SyncopeUser)attributable).getUsername());
                    values.add(attrValue);
                }
                break;
            }
            case SyncopeUserId: {
                for (AbstractAttributable attributable : attributables) {
                    UAttrValue attrValue = new UAttrValue();
                    attrValue.setStringValue(attributable.getId().toString());
                    values.add(attrValue);
                }
                break;
            }
            case Password: {
                UAttrValue attrValue = new UAttrValue();
                if (password != null) {
                    attrValue.setStringValue(password);
                }
                values.add(attrValue);
                break;
            }
        }
        LOG.debug("Retrived values '{}'", values);
        return new DefaultMapEntry(schema, values);
    }

    public static List<String> getIntValueAsStrings(AbstractAttributable attributable, SchemaMapping mapping) {
        return SchemaMappingUtil.getIntValueAsStrings(attributable, mapping, null);
    }

    public static List<String> getIntValueAsStrings(AbstractAttributable attributable, SchemaMapping mapping, String clearPassword) {
        ArrayList<String> value = new ArrayList<String>();
        if (mapping != null) {
            switch (mapping.getIntMappingType()) {
                case Username: {
                    if (!(attributable instanceof SyncopeUser)) {
                        throw new ClassCastException("mappingtype is Username, but attributable is not SyncopeUser: " + attributable.getClass().getName());
                    }
                    value.add(((SyncopeUser)attributable).getUsername());
                    break;
                }
                case Password: {
                    if (clearPassword == null) break;
                    value.add(clearPassword);
                    break;
                }
                case UserSchema: 
                case RoleSchema: 
                case MembershipSchema: {
                    Object abstractAttr = attributable.getAttribute(mapping.getIntAttrName());
                    if (abstractAttr == null || ((AbstractAttr)abstractAttr).getValues() == null) break;
                    value.addAll(((AbstractAttr)abstractAttr).getValuesAsStrings());
                    break;
                }
                case UserVirtualSchema: 
                case RoleVirtualSchema: 
                case MembershipVirtualSchema: {
                    Object abstractVirAttr = attributable.getVirtualAttribute(mapping.getIntAttrName());
                    if (abstractVirAttr == null || ((AbstractVirAttr)abstractVirAttr).getValues() == null) break;
                    value.addAll(((AbstractVirAttr)abstractVirAttr).getValues());
                    break;
                }
                case UserDerivedSchema: 
                case RoleDerivedSchema: 
                case MembershipDerivedSchema: {
                    String abstractDerAttrValue;
                    Object abstractDerAttr = attributable.getDerivedAttribute(mapping.getIntAttrName());
                    if (abstractDerAttr == null || (abstractDerAttrValue = ((AbstractDerAttr)abstractDerAttr).getValue(attributable.getAttributes())) == null) break;
                    value.add(abstractDerAttrValue);
                    break;
                }
            }
        }
        return value;
    }

    public static Class getIntMappingTypeClass(IntMappingType intMappingType) {
        Class result;
        switch (intMappingType) {
            case UserSchema: {
                result = USchema.class;
                break;
            }
            case RoleSchema: {
                result = RSchema.class;
                break;
            }
            case MembershipSchema: {
                result = MSchema.class;
                break;
            }
            case UserDerivedSchema: {
                result = UDerSchema.class;
                break;
            }
            case RoleDerivedSchema: {
                result = RDerSchema.class;
                break;
            }
            case MembershipDerivedSchema: {
                result = MDerSchema.class;
                break;
            }
            case UserVirtualSchema: {
                result = UVirSchema.class;
                break;
            }
            case RoleVirtualSchema: {
                result = RVirSchema.class;
                break;
            }
            case MembershipVirtualSchema: {
                result = MVirSchema.class;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static SchemaMapping getAccountIdMapping(Collection<SchemaMapping> mappings) {
        for (SchemaMapping mapping : mappings) {
            if (!mapping.isAccountid()) continue;
            return mapping;
        }
        return null;
    }

    public static String getAccountIdValue(AbstractAttributable attributable, Collection<SchemaMapping> mappings) {
        List<String> values = SchemaMappingUtil.getIntValueAsStrings(attributable, SchemaMappingUtil.getAccountIdMapping(mappings));
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public static String getAccountIdValue(AbstractAttributable attributable, SchemaMapping mapping) {
        List<String> values = SchemaMappingUtil.getIntValueAsStrings(attributable, mapping);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public static class SchemaMappingsWrapper {
        SchemaMapping accountIdMapping = null;
        SchemaMapping passwordMapping = null;
        final Map<String, Collection<SchemaMapping>> uMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> uVirMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> uDerMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> rMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> rVirMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> rDerMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> mMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> mVirMappings = new HashMap<String, Collection<SchemaMapping>>();
        final Map<String, Collection<SchemaMapping>> mDerMappings = new HashMap<String, Collection<SchemaMapping>>();

        public SchemaMappingsWrapper(Collection<SchemaMapping> mappings) {
            if (mappings == null) {
                return;
            }
            for (SchemaMapping mapping : mappings) {
                if (mapping.isAccountid() && this.accountIdMapping == null) {
                    this.accountIdMapping = mapping;
                    continue;
                }
                if (mapping.isPassword() && this.passwordMapping == null) {
                    this.passwordMapping = mapping;
                    continue;
                }
                String intAttrName = SchemaMappingUtil.getIntAttrName(mapping);
                switch (mapping.getIntMappingType()) {
                    case Password: {
                        if (this.passwordMapping != null) break;
                        this.passwordMapping = mapping;
                        break;
                    }
                    case SyncopeUserId: 
                    case Username: 
                    case UserSchema: {
                        if (this.uMappings.get(intAttrName) == null) {
                            this.uMappings.put(intAttrName, new HashSet());
                        }
                        this.uMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case RoleSchema: {
                        if (this.rMappings.get(intAttrName) == null) {
                            this.rMappings.put(intAttrName, new HashSet());
                        }
                        this.rMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case MembershipSchema: {
                        if (this.mMappings.get(intAttrName) == null) {
                            this.mMappings.put(intAttrName, new HashSet());
                        }
                        this.mMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case UserDerivedSchema: {
                        if (this.uDerMappings.get(intAttrName) == null) {
                            this.uDerMappings.put(intAttrName, new HashSet());
                        }
                        this.uDerMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case RoleDerivedSchema: {
                        if (this.rDerMappings.get(intAttrName) == null) {
                            this.rDerMappings.put(intAttrName, new HashSet());
                        }
                        this.rDerMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case MembershipDerivedSchema: {
                        if (this.mDerMappings.get(intAttrName) == null) {
                            this.mDerMappings.put(intAttrName, new HashSet());
                        }
                        this.mDerMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case UserVirtualSchema: {
                        if (this.uVirMappings.get(intAttrName) == null) {
                            this.uVirMappings.put(intAttrName, new HashSet());
                        }
                        this.uVirMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case RoleVirtualSchema: {
                        if (this.rVirMappings.get(intAttrName) == null) {
                            this.rVirMappings.put(intAttrName, new HashSet());
                        }
                        this.rVirMappings.get(intAttrName).add(mapping);
                        break;
                    }
                    case MembershipVirtualSchema: {
                        if (this.mVirMappings.get(intAttrName) == null) {
                            this.mVirMappings.put(intAttrName, new HashSet());
                        }
                        this.mVirMappings.get(intAttrName).add(mapping);
                        break;
                    }
                }
            }
        }

        public SchemaMapping getAccountIdMapping() {
            return this.accountIdMapping;
        }

        public Map<String, Collection<SchemaMapping>> getmDerMappings() {
            return this.mDerMappings;
        }

        public Map<String, Collection<SchemaMapping>> getmMappings() {
            return this.mMappings;
        }

        public Map<String, Collection<SchemaMapping>> getmVirMappings() {
            return this.mVirMappings;
        }

        public SchemaMapping getPasswordMapping() {
            return this.passwordMapping;
        }

        public Map<String, Collection<SchemaMapping>> getrDerMappings() {
            return this.rDerMappings;
        }

        public Map<String, Collection<SchemaMapping>> getrMappings() {
            return this.rMappings;
        }

        public Map<String, Collection<SchemaMapping>> getrVirMappings() {
            return this.rVirMappings;
        }

        public Map<String, Collection<SchemaMapping>> getuDerMappings() {
            return this.uDerMappings;
        }

        public Map<String, Collection<SchemaMapping>> getuMappings() {
            return this.uMappings;
        }

        public Map<String, Collection<SchemaMapping>> getuVirMappings() {
            return this.uVirMappings;
        }
    }
}

