/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.util.Collection;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JexlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JexlUtil.class);
    @Autowired
    private JexlEngine jexlEngine;

    public boolean isExpressionValid(String expression) {
        boolean result;
        try {
            this.jexlEngine.createExpression(expression);
            result = true;
        }
        catch (JexlException e) {
            LOG.error("Invalid jexl expression: " + expression, (Throwable)e);
            result = false;
        }
        return result;
    }

    public String evaluate(String expression, JexlContext jexlContext) {
        String result = "";
        if (expression != null && !expression.isEmpty() && jexlContext != null) {
            try {
                Expression jexlExpression = this.jexlEngine.createExpression(expression);
                Object evaluated = jexlExpression.evaluate(jexlContext);
                if (evaluated != null) {
                    result = evaluated.toString();
                }
            }
            catch (JexlException e) {
                LOG.error("Invalid jexl expression: " + expression, (Throwable)e);
                result = "";
            }
        } else {
            LOG.debug("Expression not provided or invalid context");
        }
        return result;
    }

    public String evaluate(String expression, AbstractAttributable attributable) {
        MapContext jexlContext = new MapContext();
        if (attributable instanceof SyncopeUser) {
            SyncopeUser user = (SyncopeUser)attributable;
            jexlContext.set("username", (Object)(user.getUsername() != null ? user.getUsername() : ""));
            jexlContext.set("creationDate", (Object)(user.getCreationDate() != null ? user.getDateFormatter().format(user.getCreationDate()) : ""));
            jexlContext.set("lastLoginDate", (Object)(user.getLastLoginDate() != null ? user.getDateFormatter().format(user.getLastLoginDate()) : ""));
            jexlContext.set("failedLogins", user.getFailedLogins() != null ? user.getFailedLogins() : "");
            jexlContext.set("changePwdDate", (Object)(user.getChangePwdDate() != null ? user.getDateFormatter().format(user.getChangePwdDate()) : ""));
        }
        this.addAttrsToContext(attributable.getAttributes(), (JexlContext)jexlContext);
        this.addDerAttrsToContext(attributable.getDerivedAttributes(), attributable.getAttributes(), (JexlContext)jexlContext);
        return this.evaluate(expression, (JexlContext)jexlContext);
    }

    public JexlContext addAttrsToContext(Collection<? extends AbstractAttr> attributes, JexlContext jexlContext) {
        JexlContext context = jexlContext == null ? new MapContext() : jexlContext;
        for (AbstractAttr abstractAttr : attributes) {
            List<String> attributeValues = abstractAttr.getValuesAsStrings();
            String expressionValue = attributeValues.isEmpty() ? "" : attributeValues.get(0);
            LOG.debug("Add attribute {} with value {}", new Object[]{((AbstractSchema)abstractAttr.getSchema()).getName(), expressionValue});
            context.set(((AbstractSchema)abstractAttr.getSchema()).getName(), (Object)expressionValue);
        }
        return context;
    }

    public JexlContext addDerAttrsToContext(Collection<? extends AbstractDerAttr> derAttributes, Collection<? extends AbstractAttr> attributes, JexlContext jexlContext) {
        JexlContext context = jexlContext == null ? new MapContext() : jexlContext;
        for (AbstractDerAttr abstractDerAttr : derAttributes) {
            String expressionValue = abstractDerAttr.getValue(attributes);
            if (expressionValue == null) {
                expressionValue = "";
            }
            LOG.debug("Add derived attribute {} with value {}", new Object[]{((AbstractDerSchema)abstractDerAttr.getDerivedSchema()).getName(), expressionValue});
            context.set(((AbstractDerSchema)abstractDerAttr.getDerivedSchema()).getName(), (Object)expressionValue);
        }
        return context;
    }

    public String evaluate(String expression, AbstractAttributableTO attributableTO) {
        String expressionValue;
        List attributeValues;
        MapContext context = new MapContext();
        if (attributableTO instanceof UserTO) {
            UserTO user = (UserTO)attributableTO;
            context.set("username", (Object)(user.getUsername() != null ? user.getUsername() : ""));
            context.set("password", (Object)(user.getPassword() != null ? user.getPassword() : ""));
        }
        for (AttributeTO attribute : attributableTO.getAttributes()) {
            attributeValues = attribute.getValues();
            expressionValue = attributeValues.isEmpty() ? "" : (String)attributeValues.get(0);
            LOG.debug("Add attribute {} with value {}", new Object[]{attribute.getSchema(), expressionValue});
            context.set(attribute.getSchema(), (Object)expressionValue);
        }
        for (AttributeTO attribute : attributableTO.getDerivedAttributes()) {
            attributeValues = attribute.getValues();
            expressionValue = attributeValues.isEmpty() ? "" : (String)attributeValues.get(0);
            LOG.debug("Add attribute {} with value {}", new Object[]{attribute.getSchema(), expressionValue});
            context.set(attribute.getSchema(), (Object)expressionValue);
        }
        for (AttributeTO attribute : attributableTO.getVirtualAttributes()) {
            attributeValues = attribute.getValues();
            expressionValue = attributeValues.isEmpty() ? "" : (String)attributeValues.get(0);
            LOG.debug("Add attribute {} with value {}", new Object[]{attribute.getSchema(), expressionValue});
            context.set(attribute.getSchema(), (Object)expressionValue);
        }
        return this.evaluate(expression, (JexlContext)context);
    }
}

