/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.syncope.client.SyncopeConstants;
import org.apache.syncope.core.util.multiparent.MultiParentNode;
import org.apache.syncope.core.util.multiparent.MultiParentNodeOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class ImportExport
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ImportExport.class);
    private static final String ROOT_ELEMENT = "dataset";
    protected static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(SyncopeConstants.DEFAULT_DATE_PATTERN);
        }
    };
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSchema() {
        String schema = null;
        InputStream dbPropsStream = null;
        try {
            dbPropsStream = this.getClass().getResourceAsStream("/persistence.properties");
            Properties dbProps = new Properties();
            dbProps.load(dbPropsStream);
            schema = dbProps.getProperty("database.schema");
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find persistence.properties", (Throwable)e);
            } else {
                LOG.error("Could not find persistence.properties");
            }
        }
        finally {
            if (dbPropsStream != null) {
                try {
                    dbPropsStream.close();
                }
                catch (IOException e) {
                    LOG.error("While trying to read persistence.properties", (Throwable)e);
                }
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParameters(String tableName, Attributes attrs, Query query) {
        HashMap<String, Integer> colTypes = new HashMap<String, Integer>();
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        ResultSet rs = null;
        Statement stmt = null;
        try {
            String queryString = "SELECT * FROM " + tableName;
            stmt = conn.prepareStatement(queryString);
            rs = stmt.executeQuery();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                colTypes.put(rs.getMetaData().getColumnName(i + 1).toUpperCase(), rs.getMetaData().getColumnType(i + 1));
            }
        }
        catch (SQLException e) {
            LOG.error("While", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing statement", (Throwable)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
        }
        block43: for (int i = 0; i < attrs.getLength(); ++i) {
            Integer colType = (Integer)colTypes.get(attrs.getQName(i).toUpperCase());
            if (colType == null) {
                LOG.warn("No column type found for {}", (Object)attrs.getQName(i).toUpperCase());
                colType = 12;
            }
            switch (colType) {
                case -6: 
                case 4: 
                case 5: {
                    try {
                        query.setParameter(i + 1, (Object)Integer.valueOf(attrs.getValue(i)));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Integer '{}'", (Object)attrs.getValue(i));
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case -5: 
                case 2: 
                case 3: {
                    try {
                        query.setParameter(i + 1, (Object)Long.valueOf(attrs.getValue(i)));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Long '{}'", (Object)attrs.getValue(i));
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case 8: {
                    try {
                        query.setParameter(i + 1, (Object)Double.valueOf(attrs.getValue(i)));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Double '{}'", (Object)attrs.getValue(i));
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case 6: 
                case 7: {
                    try {
                        query.setParameter(i + 1, (Object)Float.valueOf(attrs.getValue(i)));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Float '{}'", (Object)attrs.getValue(i));
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case 91: 
                case 92: 
                case 93: {
                    try {
                        query.setParameter(i + 1, DateUtils.parseDate((String)attrs.getValue(i), (String[])SyncopeConstants.DATE_PATTERNS), TemporalType.TIMESTAMP);
                    }
                    catch (ParseException e) {
                        LOG.error("Unparsable Date '{}'", (Object)attrs.getValue(i));
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case -7: 
                case 16: {
                    query.setParameter(i + 1, (Object)("1".equals(attrs.getValue(i)) ? Boolean.TRUE : Boolean.FALSE));
                    continue block43;
                }
                case -4: 
                case -3: 
                case -2: {
                    try {
                        query.setParameter(i + 1, (Object)Hex.decode((CharSequence)attrs.getValue(i)));
                    }
                    catch (IllegalArgumentException e) {
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    continue block43;
                }
                case 2004: {
                    try {
                        query.setParameter(i + 1, (Object)Hex.decode((CharSequence)attrs.getValue(i)));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Error decoding hex string to specify a blob parameter", (Throwable)e);
                        query.setParameter(i + 1, (Object)attrs.getValue(i));
                    }
                    catch (Exception e) {
                        LOG.warn("Error creating a new blob parameter", (Throwable)e);
                    }
                    continue block43;
                }
                default: {
                    query.setParameter(i + 1, (Object)attrs.getValue(i));
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (ROOT_ELEMENT.equals(qName)) {
            return;
        }
        StringBuilder queryString = new StringBuilder("INSERT INTO ").append(qName).append('(');
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < atts.getLength(); ++i) {
            queryString.append(atts.getQName(i));
            values.append('?');
            if (i >= atts.getLength() - 1) continue;
            queryString.append(',');
            values.append(',');
        }
        queryString.append(") VALUES (").append((CharSequence)values).append(')');
        Query query = this.entityManager.createNativeQuery(queryString.toString());
        this.setParameters(qName, atts, query);
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportTable(TransformerHandler handler, Connection conn, String tableName) throws SQLException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet pkeyRS = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            pkeyRS = meta.getPrimaryKeys(null, null, tableName);
            StringBuilder orderBy = new StringBuilder();
            while (pkeyRS.next()) {
                String columnName = pkeyRS.getString("COLUMN_NAME");
                if (columnName == null) continue;
                if (orderBy.length() > 0) {
                    orderBy.append(",");
                }
                orderBy.append(columnName);
            }
            stmt = conn.prepareStatement("SELECT * FROM " + tableName + " a" + (orderBy.length() > 0 ? " ORDER BY " + orderBy : ""));
            rs = stmt.executeQuery();
            int rowNo = 0;
            while (rs.next()) {
                attrs.clear();
                ResultSetMetaData rsMeta = rs.getMetaData();
                for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                    Integer columnType;
                    String columnName = rsMeta.getColumnName(i + 1);
                    String value = this.getValues(rs, columnName, columnType = Integer.valueOf(rsMeta.getColumnType(i + 1)));
                    if (value == null) continue;
                    attrs.addAttribute("", "", columnName, "CDATA", value);
                }
                handler.startElement("", "", tableName, attrs);
                handler.endElement("", "", tableName);
                ++rowNo;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
            if (pkeyRS != null) {
                try {
                    pkeyRS.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing result set", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> sortByForeignKeys(Connection conn, Set<String> tableNames, String schema) throws SQLException {
        HashSet roots = new HashSet();
        DatabaseMetaData meta = conn.getMetaData();
        TreeMap<String, MultiParentNode<String>> exploited = new TreeMap<String, MultiParentNode<String>>(String.CASE_INSENSITIVE_ORDER);
        HashSet<String> pkTableNames = new HashSet<String>();
        for (String tableName : tableNames) {
            MultiParentNode<String> node = (MultiParentNode<String>)exploited.get(tableName);
            if (node == null) {
                node = new MultiParentNode<String>(tableName);
                roots.add(node);
                exploited.put(tableName, node);
            }
            ResultSet rs = null;
            pkTableNames.clear();
            try {
                rs = meta.getImportedKeys(conn.getCatalog(), this.readSchema(), tableName);
                while (rs.next()) {
                    pkTableNames.add(rs.getString("PKTABLE_NAME"));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("While closing tables result set", (Throwable)e);
                    }
                }
            }
            for (String pkTableName : pkTableNames) {
                if (tableName.equalsIgnoreCase(pkTableName)) continue;
                MultiParentNode<String> pkNode = (MultiParentNode<String>)exploited.get(pkTableName);
                if (pkNode == null) {
                    pkNode = new MultiParentNode<String>(pkTableName);
                    roots.add(pkNode);
                    exploited.put(pkTableName, pkNode);
                }
                pkNode.addChild(node);
                if (!roots.contains(node)) continue;
                roots.remove(node);
            }
        }
        ArrayList<String> sortedTableNames = new ArrayList<String>(tableNames.size());
        MultiParentNodeOp.traverseTree(roots, sortedTableNames);
        Collections.reverse(sortedTableNames);
        return sortedTableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream os) throws SAXException, TransformerConfigurationException {
        StreamResult streamResult = new StreamResult(os);
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = transformerFactory.newTransformerHandler();
        Transformer serializer = handler.getTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        handler.setResult(streamResult);
        handler.startDocument();
        handler.startElement("", "", ROOT_ELEMENT, new AttributesImpl());
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        ResultSet rs = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            String schema = this.readSchema();
            rs = meta.getTables(null, schema, null, new String[]{"TABLE"});
            HashSet<String> tableNames = new HashSet<String>();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (tableName.toUpperCase().startsWith("QRTZ_") || tableName.toUpperCase().startsWith("LOGGING_")) continue;
                tableNames.add(tableName);
            }
            for (String tableName : this.sortByForeignKeys(conn, tableNames, schema)) {
                this.doExportTable(handler, conn, tableName);
            }
        }
        catch (SQLException e) {
            LOG.error("While exporting database content", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error("While closing tables result set", (Throwable)e);
                }
            }
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
        }
        handler.endElement("", "", ROOT_ELEMENT);
        handler.endDocument();
    }

    private String getValues(ResultSet rs, String columnName, Integer columnType) throws SQLException {
        String res = null;
        try {
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: {
                    InputStream is = rs.getBinaryStream(columnName);
                    if (is != null) {
                        res = new String(Hex.encode((byte[])IOUtils.toByteArray((InputStream)is)));
                    }
                    break;
                }
                case 2004: {
                    Blob blob = rs.getBlob(columnName);
                    if (blob != null) {
                        res = new String(Hex.encode((byte[])IOUtils.toByteArray((InputStream)blob.getBinaryStream())));
                    }
                    break;
                }
                case -7: 
                case 16: {
                    if (rs.getBoolean(columnName)) {
                        res = "1";
                        break;
                    }
                    res = "0";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(columnName);
                    if (timestamp != null) {
                        res = DATE_FORMAT.get().format(new Date(timestamp.getTime()));
                    }
                    break;
                }
                default: {
                    res = rs.getString(columnName);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving hexadecimal string", (Throwable)e);
        }
        return res;
    }
}

