/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class EntitlementUtil {
    private static final Pattern ROLE_ENTITLEMENT_NAME_PATTERN = Pattern.compile("^ROLE_([\\d])+");
    private static final Logger LOG = LoggerFactory.getLogger(EntitlementUtil.class);

    public static Set<String> getOwnedEntitlementNames() {
        HashSet<String> result = new HashSet<String>();
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx != null && ctx.getAuthentication() != null && ctx.getAuthentication().getAuthorities() != null) {
            for (GrantedAuthority authority : ctx.getAuthentication().getAuthorities()) {
                result.add(authority.getAuthority());
            }
        }
        return result;
    }

    public static String getEntitlementNameFromRoleId(Long roleId) {
        return "ROLE_" + roleId;
    }

    public static boolean isRoleEntitlement(String entitlementName) {
        return ROLE_ENTITLEMENT_NAME_PATTERN.matcher(entitlementName).matches();
    }

    public static Long getRoleId(String entitlementName) {
        Long result = null;
        if (EntitlementUtil.isRoleEntitlement(entitlementName)) {
            try {
                result = Long.valueOf(entitlementName.substring(entitlementName.indexOf("_") + 1));
            }
            catch (Exception e) {
                LOG.error("unable to parse {} to Long", (Object)entitlementName, (Object)e);
            }
        }
        return result;
    }

    public static Set<Long> getRoleIds(Set<String> entitlements) {
        HashSet<Long> result = new HashSet<Long>();
        for (String entitlement : entitlements) {
            Long roleId;
            if (!EntitlementUtil.isRoleEntitlement(entitlement) || (roleId = EntitlementUtil.getRoleId(entitlement)) == null) continue;
            result.add(roleId);
        }
        return result;
    }

    public static Set<Long> getRoleIds(List<Entitlement> entitlements) {
        HashSet<String> names = new HashSet<String>(entitlements.size());
        for (Entitlement entitlement : entitlements) {
            names.add(entitlement.getName());
        }
        return EntitlementUtil.getRoleIds(names);
    }
}

