/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javassist.NotFoundException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.client.to.ConnObjectTO;
import org.apache.syncope.client.to.MembershipTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.util.AttributableOperations;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.util.ApplicationContextProvider;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.core.util.SchemaMappingUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnObjectUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnObjectUtil.class);
    @Autowired
    private JexlUtil jexlUtil;
    @Autowired
    private UserDataBinder userDataBinder;

    @Transactional(readOnly=true)
    public UserTO getUserTO(ConnectorObject obj, SyncTask syncTask) {
        UserTO userTO = this.getUserTOFromConnObject(obj, syncTask);
        if (StringUtils.isBlank((String)userTO.getPassword())) {
            userTO.setPassword(RandomStringUtils.randomAlphanumeric((int)16));
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserMod getUserMod(Long userId, ConnectorObject obj, SyncTask syncTask) throws NotFoundException, UnauthorizedRoleException {
        SyncopeUser user = this.userDataBinder.getUserFromId(userId);
        UserTO original = this.userDataBinder.getUserTO(user);
        UserTO updated = this.getUserTOFromConnObject(obj, syncTask);
        updated.setId(userId.longValue());
        if (StringUtils.isBlank((String)updated.getPassword()) || this.userDataBinder.verifyPassword(user, updated.getPassword())) {
            updated.setPassword(null);
        }
        UserMod userMod = AttributableOperations.diff((UserTO)updated, (UserTO)original, (boolean)true);
        return userMod;
    }

    private UserTO getUserTOFromConnObject(ConnectorObject obj, SyncTask syncTask) {
        UserTO userTO = new UserTO();
        for (SchemaMapping mapping : syncTask.getResource().getMappings()) {
            Attribute attribute = obj.getAttributeByName(SchemaMappingUtil.getExtAttrName(mapping));
            switch (mapping.getIntMappingType()) {
                case SyncopeUserId: {
                    break;
                }
                case Password: {
                    if (attribute == null || attribute.getValue() == null || attribute.getValue().isEmpty()) break;
                    userTO.setPassword(this.getPassword(attribute.getValue().get(0)));
                    break;
                }
                case Username: {
                    userTO.setUsername(attribute == null || attribute.getValue().isEmpty() ? null : attribute.getValue().get(0).toString());
                    break;
                }
                case UserSchema: {
                    AttributeTO attributeTO = new AttributeTO();
                    attributeTO.setSchema(mapping.getIntAttrName());
                    for (Object value : attribute == null || attribute.getValue() == null ? Collections.emptyList() : attribute.getValue()) {
                        attributeTO.addValue(value.toString());
                    }
                    userTO.addAttribute(attributeTO);
                    break;
                }
                case UserDerivedSchema: {
                    AttributeTO attributeTO = new AttributeTO();
                    attributeTO.setSchema(mapping.getIntAttrName());
                    userTO.addDerivedAttribute(attributeTO);
                    break;
                }
                case UserVirtualSchema: {
                    AttributeTO attributeTO = new AttributeTO();
                    attributeTO.setSchema(mapping.getIntAttrName());
                    for (Object value : attribute == null || attribute.getValue() == null ? Collections.emptyList() : attribute.getValue()) {
                        attributeTO.addValue(value.toString());
                    }
                    userTO.addVirtualAttribute(attributeTO);
                    break;
                }
            }
        }
        UserTO template = syncTask.getUserTemplate();
        if (template != null) {
            String evaluated;
            if (StringUtils.isBlank((String)userTO.getUsername()) && StringUtils.isNotBlank((String)template.getUsername()) && StringUtils.isNotBlank((String)(evaluated = this.jexlUtil.evaluate(template.getUsername(), (AbstractAttributableTO)userTO)))) {
                userTO.setUsername(template.getUsername());
            }
            if (StringUtils.isBlank((String)userTO.getPassword()) && StringUtils.isNotBlank((String)template.getPassword()) && StringUtils.isNotBlank((String)(evaluated = this.jexlUtil.evaluate(template.getPassword(), (AbstractAttributableTO)userTO)))) {
                userTO.setPassword(template.getPassword());
            }
            this.fillFromTemplate((AbstractAttributableTO)userTO, (AbstractAttributableTO)template);
            for (String resource : template.getResources()) {
                userTO.addResource(resource);
            }
            Map currentMembs = userTO.getMembershipMap();
            for (MembershipTO membTO : template.getMemberships()) {
                MembershipTO membTBU;
                if (currentMembs.containsKey(membTO.getRoleId())) {
                    membTBU = (MembershipTO)currentMembs.get(membTO.getRoleId());
                } else {
                    membTBU = new MembershipTO();
                    membTBU.setRoleId(membTO.getRoleId());
                    userTO.addMembership(membTBU);
                }
                this.fillFromTemplate((AbstractAttributableTO)membTBU, (AbstractAttributableTO)membTO);
            }
        }
        return userTO;
    }

    public String getPassword(Object pwd) {
        final StringBuilder result = new StringBuilder();
        if (pwd instanceof GuardedString) {
            ((GuardedString)pwd).access(new GuardedString.Accessor(){

                public void access(char[] clearChars) {
                    result.append(clearChars);
                }
            });
        } else if (pwd instanceof GuardedByteArray) {
            ((GuardedByteArray)pwd).access(new GuardedByteArray.Accessor(){

                public void access(byte[] clearBytes) {
                    result.append(new String(clearBytes));
                }
            });
        } else if (pwd instanceof String) {
            result.append((String)pwd);
        } else {
            result.append(pwd.toString());
        }
        return result.toString();
    }

    public ConnObjectTO getConnObjectTO(ConnectorObject connObject) {
        ConnObjectTO connObjectTO = new ConnObjectTO();
        for (Attribute attr : connObject.getAttributes()) {
            AttributeTO attrTO = new AttributeTO();
            attrTO.setSchema(attr.getName());
            if (attr.getValue() != null) {
                for (Object value : attr.getValue()) {
                    if (value == null) continue;
                    attrTO.addValue(value.toString());
                }
            }
            connObjectTO.addAttribute(attrTO);
        }
        return connObjectTO;
    }

    public void retrieveVirAttrValues(AbstractAttributable owner) {
        ConfigurableApplicationContext context = ApplicationContextProvider.getApplicationContext();
        ConnInstanceLoader connInstanceLoader = (ConnInstanceLoader)context.getBean(ConnInstanceLoader.class);
        HashMap<SchemaMappingUtil.SchemaMappingsWrapper, ConnectorObject> remoteObjects = new HashMap<SchemaMappingUtil.SchemaMappingsWrapper, ConnectorObject>();
        for (ExternalResource externalResource : owner.getResources()) {
            LOG.debug("Retrieve remote object from '{}'", (Object)externalResource.getName());
            try {
                ConnectorFacadeProxy connector = connInstanceLoader.getConnector(externalResource);
                SchemaMappingUtil.SchemaMappingsWrapper mappings = new SchemaMappingUtil.SchemaMappingsWrapper(externalResource.getMappings());
                String accountId = SchemaMappingUtil.getAccountIdValue(owner, mappings.getAccountIdMapping());
                LOG.debug("Search for object with accountId '{}'", (Object)accountId);
                if (!StringUtils.isNotBlank((String)accountId)) continue;
                HashSet<String> extAttrNames = new HashSet<String>();
                for (Collection<SchemaMapping> virAttrMappings : mappings.getuVirMappings().values()) {
                    for (SchemaMapping virAttrMapping : virAttrMappings) {
                        extAttrNames.add(SchemaMappingUtil.getExtAttrName(virAttrMapping));
                    }
                }
                if (extAttrNames == null) continue;
                OperationOptionsBuilder oob = new OperationOptionsBuilder();
                oob.setAttributesToGet(extAttrNames);
                ConnectorObject connectorObject = connector.getObject(ObjectClass.ACCOUNT, new Uid(accountId), oob.build());
                if (connectorObject != null) {
                    remoteObjects.put(mappings, connectorObject);
                }
                LOG.debug("Retrieved remotye object {}", (Object)connectorObject);
            }
            catch (Exception e) {
                LOG.error("Unable to retrieve virtual attribute values on '{}'", (Object)externalResource.getName(), (Object)e);
            }
        }
        for (AbstractVirAttr abstractVirAttr : owner.getVirtualAttributes()) {
            LOG.debug("Provide value for virtual attribute '{}'", (Object)((AbstractVirSchema)abstractVirAttr.getVirtualSchema()).getName());
            for (SchemaMappingUtil.SchemaMappingsWrapper mappings : remoteObjects.keySet()) {
                Collection<SchemaMapping> virAttrMappings = mappings.getuVirMappings().get(((AbstractVirSchema)abstractVirAttr.getVirtualSchema()).getName());
                if (virAttrMappings == null) continue;
                for (SchemaMapping virAttrMapping : virAttrMappings) {
                    String extAttrName = SchemaMappingUtil.getExtAttrName(virAttrMapping);
                    Attribute extAttr = ((ConnectorObject)remoteObjects.get(mappings)).getAttributeByName(extAttrName);
                    if (extAttr == null || extAttr.getValue() == null || extAttr.getValue().isEmpty()) continue;
                    for (Object obj : extAttr.getValue()) {
                        if (obj == null) continue;
                        abstractVirAttr.addValue(obj.toString());
                    }
                }
            }
        }
        LOG.debug("Virtual attribute evaluation ended");
    }

    private void fillFromTemplate(AbstractAttributableTO attributableTO, AbstractAttributableTO template) {
        Map currentAttrMap = attributableTO.getAttributeMap();
        for (AttributeTO attrTO : template.getAttributes()) {
            if (currentAttrMap.containsKey(attrTO.getSchema())) continue;
            attributableTO.addAttribute(this.evaluateAttrTemplate(attributableTO, attrTO));
        }
        currentAttrMap = attributableTO.getDerivedAttributeMap();
        for (AttributeTO attrTO : template.getDerivedAttributes()) {
            if (currentAttrMap.containsKey(attrTO.getSchema())) continue;
            attributableTO.addDerivedAttribute(attrTO);
        }
        currentAttrMap = attributableTO.getVirtualAttributeMap();
        for (AttributeTO attrTO : template.getDerivedAttributes()) {
            if (currentAttrMap.containsKey(attrTO.getSchema())) continue;
            attributableTO.addVirtualAttribute(this.evaluateAttrTemplate(attributableTO, attrTO));
        }
    }

    private AttributeTO evaluateAttrTemplate(AbstractAttributableTO attributableTO, AttributeTO template) {
        AttributeTO result = new AttributeTO();
        result.setSchema(template.getSchema());
        if (template.getValues() != null && !template.getValues().isEmpty()) {
            for (String value : template.getValues()) {
                String evaluated = this.jexlUtil.evaluate(value, attributableTO);
                if (!StringUtils.isNotBlank((String)evaluated)) continue;
                result.addValue(evaluated);
            }
        }
        return result;
    }
}

