/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javassist.NotFoundException;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.MissingConfKeyException;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnBundleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnBundleManager.class);
    @Autowired
    private ConfDAO confDAO;

    public ConnectorInfoManager getConnectorManager() throws NotFoundException, MissingConfKeyException {
        SyncopeConf connectorBundleDir = this.confDAO.find("connid.bundles.directory");
        File bundleDirectory = new File(connectorBundleDir.getValue());
        String[] bundleFiles = bundleDirectory.list();
        if (bundleFiles == null) {
            throw new NotFoundException("Bundles from dir " + connectorBundleDir.getValue());
        }
        ArrayList<URL> bundleFileURLs = new ArrayList<URL>();
        for (String file : bundleFiles) {
            try {
                bundleFileURLs.add(IOUtil.makeURL((File)bundleDirectory, (String)file));
            }
            catch (Exception ignore) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(bundleDirectory.toString() + "/" + file + "\"" + " is not a valid connector bundle.", (Throwable)ignore);
            }
        }
        if (bundleFileURLs.isEmpty()) {
            throw new NotFoundException("Bundles from dir " + connectorBundleDir.getValue());
        }
        LOG.debug("Bundle file URLs: {}", bundleFileURLs);
        ConnectorInfoManager manager = ConnectorInfoManagerFactory.getInstance().getLocalManager(bundleFileURLs.toArray(new URL[0]));
        if (manager == null) {
            throw new NotFoundException("Connector Info Manager");
        }
        return manager;
    }

    public ConfigurationProperties getConfigurationProperties(String bundleName, String version, String connectorName) throws NotFoundException {
        ConnectorInfo info;
        ConnectorKey key = new ConnectorKey(bundleName, version, connectorName);
        if (key == null) {
            throw new NotFoundException("Connector Key");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nBundle name: " + key.getBundleName() + "\nBundle version: " + key.getBundleVersion() + "\nBundle class: " + key.getConnectorName());
        }
        try {
            info = this.getConnectorManager().findConnectorInfo(key);
            if (info == null) {
                throw new NotFoundException("Connector Info for key " + key);
            }
        }
        catch (MissingConfKeyException e) {
            throw new NotFoundException("Connector Info for key " + key, (Exception)e);
        }
        return this.getConfigurationProperties(info);
    }

    public ConfigurationProperties getConfigurationProperties(ConnectorInfo info) throws NotFoundException {
        if (info == null) {
            throw new NotFoundException("Invalid: connector info is null");
        }
        APIConfiguration apiConfig = info.createDefaultAPIConfiguration();
        if (apiConfig == null) {
            throw new NotFoundException("Default API configuration");
        }
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        if (properties == null) {
            throw new NotFoundException("Configuration properties");
        }
        if (LOG.isDebugEnabled()) {
            for (String propName : properties.getPropertyNames()) {
                LOG.debug("\nProperty Name: " + properties.getProperty(propName).getName() + "\nProperty Type: " + properties.getProperty(propName).getType());
            }
        }
        return properties;
    }
}

