/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.util;

import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.membership.MAttr;
import org.apache.syncope.core.persistence.beans.membership.MAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.membership.MAttrValue;
import org.apache.syncope.core.persistence.beans.membership.MDerAttr;
import org.apache.syncope.core.persistence.beans.membership.MDerSchema;
import org.apache.syncope.core.persistence.beans.membership.MSchema;
import org.apache.syncope.core.persistence.beans.membership.MVirAttr;
import org.apache.syncope.core.persistence.beans.membership.MVirSchema;
import org.apache.syncope.core.persistence.beans.role.RAttr;
import org.apache.syncope.core.persistence.beans.role.RAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.role.RAttrValue;
import org.apache.syncope.core.persistence.beans.role.RDerAttr;
import org.apache.syncope.core.persistence.beans.role.RDerSchema;
import org.apache.syncope.core.persistence.beans.role.RSchema;
import org.apache.syncope.core.persistence.beans.role.RVirAttr;
import org.apache.syncope.core.persistence.beans.role.RVirSchema;
import org.apache.syncope.core.persistence.beans.user.UAttr;
import org.apache.syncope.core.persistence.beans.user.UAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.user.UAttrValue;
import org.apache.syncope.core.persistence.beans.user.UDerAttr;
import org.apache.syncope.core.persistence.beans.user.UDerSchema;
import org.apache.syncope.core.persistence.beans.user.USchema;
import org.apache.syncope.core.persistence.beans.user.UVirAttr;
import org.apache.syncope.core.persistence.beans.user.UVirSchema;
import org.apache.syncope.types.AttributableType;
import org.apache.syncope.types.IntMappingType;

public class AttributableUtil {
    private final AttributableType type;

    public static AttributableUtil getInstance(AttributableType type) {
        return new AttributableUtil(type);
    }

    public static AttributableUtil valueOf(String name) {
        return new AttributableUtil(AttributableType.valueOf((String)name));
    }

    private AttributableUtil(AttributableType type) {
        this.type = type;
    }

    public AttributableType getType() {
        return this.type;
    }

    public IntMappingType intMappingType() {
        IntMappingType result;
        switch (this.type) {
            case ROLE: {
                result = IntMappingType.RoleSchema;
                break;
            }
            case MEMBERSHIP: {
                result = IntMappingType.MembershipSchema;
                break;
            }
            default: {
                result = IntMappingType.UserSchema;
            }
        }
        return result;
    }

    public IntMappingType derivedIntMappingType() {
        IntMappingType result;
        switch (this.type) {
            case ROLE: {
                result = IntMappingType.RoleDerivedSchema;
                break;
            }
            case MEMBERSHIP: {
                result = IntMappingType.MembershipDerivedSchema;
                break;
            }
            default: {
                result = IntMappingType.UserDerivedSchema;
            }
        }
        return result;
    }

    public IntMappingType virtualIntMappingType() {
        IntMappingType result;
        switch (this.type) {
            case ROLE: {
                result = IntMappingType.RoleVirtualSchema;
                break;
            }
            case MEMBERSHIP: {
                result = IntMappingType.MembershipVirtualSchema;
                break;
            }
            default: {
                result = IntMappingType.UserVirtualSchema;
            }
        }
        return result;
    }

    public <T extends AbstractSchema> Class<T> schemaClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = USchema.class;
                break;
            }
            case ROLE: {
                result = RSchema.class;
                break;
            }
            case MEMBERSHIP: {
                result = MSchema.class;
            }
        }
        return result;
    }

    public <T extends AbstractSchema> T newSchema() {
        AbstractSchema result = null;
        switch (this.type) {
            case USER: {
                result = new USchema();
                break;
            }
            case ROLE: {
                result = new RSchema();
                break;
            }
            case MEMBERSHIP: {
                result = new MSchema();
            }
        }
        return (T)result;
    }

    public <T extends AbstractDerSchema> Class<T> derivedSchemaClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UDerSchema.class;
                break;
            }
            case ROLE: {
                result = RDerSchema.class;
                break;
            }
            case MEMBERSHIP: {
                result = MDerSchema.class;
            }
        }
        return result;
    }

    public <T extends AbstractVirSchema> Class<T> virtualSchemaClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UVirSchema.class;
                break;
            }
            case ROLE: {
                result = RVirSchema.class;
                break;
            }
            case MEMBERSHIP: {
                result = MVirSchema.class;
            }
        }
        return result;
    }

    public <T extends AbstractDerSchema> T newDerivedSchema() {
        AbstractDerSchema result = null;
        switch (this.type) {
            case USER: {
                result = new UDerSchema();
                break;
            }
            case ROLE: {
                result = new RDerSchema();
                break;
            }
            case MEMBERSHIP: {
                result = new MDerSchema();
            }
        }
        return (T)result;
    }

    public <T extends AbstractAttr> Class<T> attributeClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UAttr.class;
                break;
            }
            case ROLE: {
                result = RAttr.class;
                break;
            }
            case MEMBERSHIP: {
                result = MAttr.class;
            }
        }
        return result;
    }

    public <T extends AbstractAttr> T newAttribute() {
        AbstractAttr result = null;
        switch (this.type) {
            case USER: {
                result = new UAttr();
                break;
            }
            case ROLE: {
                result = new RAttr();
                break;
            }
            case MEMBERSHIP: {
                result = new MAttr();
            }
        }
        return (T)result;
    }

    public <T extends AbstractDerAttr> Class<T> derivedAttributeClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UDerAttr.class;
                break;
            }
            case ROLE: {
                result = RDerAttr.class;
                break;
            }
            case MEMBERSHIP: {
                result = MDerAttr.class;
            }
        }
        return result;
    }

    public <T extends AbstractVirAttr> Class<T> virtualAttributeClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UVirAttr.class;
                break;
            }
            case ROLE: {
                result = RVirAttr.class;
                break;
            }
            case MEMBERSHIP: {
                result = MVirAttr.class;
            }
        }
        return result;
    }

    public <T extends AbstractDerAttr> T newDerivedAttribute() {
        AbstractDerAttr result = null;
        switch (this.type) {
            case USER: {
                result = new UDerAttr();
                break;
            }
            case ROLE: {
                result = new RDerAttr();
                break;
            }
            case MEMBERSHIP: {
                result = new MDerAttr();
            }
        }
        return (T)result;
    }

    public <T extends AbstractVirAttr> T newVirtualAttribute() {
        AbstractVirAttr result = null;
        switch (this.type) {
            case USER: {
                result = new UVirAttr();
                break;
            }
            case ROLE: {
                result = new RVirAttr();
                break;
            }
            case MEMBERSHIP: {
                result = new MVirAttr();
            }
        }
        return (T)result;
    }

    public <T extends AbstractVirSchema> T newVirtualSchema() {
        AbstractVirSchema result = null;
        switch (this.type) {
            case USER: {
                result = new UVirSchema();
                break;
            }
            case ROLE: {
                result = new RVirSchema();
                break;
            }
            case MEMBERSHIP: {
                result = new MVirSchema();
            }
        }
        return (T)result;
    }

    public <T extends AbstractAttrValue> Class<T> attributeValueClass() {
        Class result = null;
        switch (this.type) {
            case USER: {
                result = UAttrValue.class;
                break;
            }
            case ROLE: {
                result = RAttrValue.class;
                break;
            }
            case MEMBERSHIP: {
                result = MAttrValue.class;
            }
        }
        return result;
    }

    public <T extends AbstractAttrValue> T newAttributeValue() {
        AbstractAttrValue result = null;
        switch (this.type) {
            case USER: {
                result = new UAttrValue();
                break;
            }
            case ROLE: {
                result = new RAttrValue();
                break;
            }
            case MEMBERSHIP: {
                result = new MAttrValue();
            }
        }
        return (T)result;
    }

    public <T extends AbstractAttrValue> T newAttributeUniqueValue() {
        AbstractAttrUniqueValue result = null;
        switch (this.type) {
            case USER: {
                result = new UAttrUniqueValue();
                break;
            }
            case ROLE: {
                result = new RAttrUniqueValue();
                break;
            }
            case MEMBERSHIP: {
                result = new MAttrUniqueValue();
            }
        }
        return (T)result;
    }
}

