/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.security;

import java.util.HashSet;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Configurable
public class SyncopeUserDetailsService
implements UserDetailsService {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private EntitlementDAO entitlementDAO;
    private String adminUser;

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        if (this.adminUser.equals(username)) {
            for (Entitlement entitlement : this.entitlementDAO.findAll()) {
                authorities.add(new SimpleGrantedAuthority(entitlement.getName()));
            }
        } else {
            SyncopeUser user = this.userDAO.find(username);
            if (user == null) {
                throw new UsernameNotFoundException("Could not find any user with id " + username);
            }
            HashSet<SyncopeRole> roles = new HashSet<SyncopeRole>(user.getRoles());
            for (SyncopeRole role : user.getRoles()) {
                roles.addAll(this.roleDAO.findAncestors(role));
            }
            for (SyncopeRole role : roles) {
                for (Entitlement entitlement : role.getEntitlements()) {
                    authorities.add(new SimpleGrantedAuthority(entitlement.getName()));
                }
            }
        }
        return new User(username, "<PASSWORD_PLACEHOLDER>", true, true, true, true, authorities);
    }
}

