/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.security;

import java.util.Date;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.security.SyncopeUserDetailsService;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.CipherAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.transaction.annotation.Transactional;

@Configurable
public class SyncopeAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeAuthenticationProvider.class);
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private UserDAO userDAO;
    private SyncopeUserDetailsService userDetailsService;
    private String adminUser;
    private String adminMD5Password;

    public String getAdminMD5Password() {
        return this.adminMD5Password;
    }

    public void setAdminMD5Password(String adminMD5Password) {
        this.adminMD5Password = adminMD5Password;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public SyncopeUserDetailsService getSyncopeUserDetailsService() {
        return this.userDetailsService;
    }

    public void setSyncopeUserDetailsService(SyncopeUserDetailsService syncopeUserDetailsService) {
        this.userDetailsService = syncopeUserDetailsService;
    }

    @Transactional(noRollbackFor={BadCredentialsException.class, DisabledException.class})
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token;
        boolean authenticated = false;
        SyncopeUser passwordUser = new SyncopeUser();
        SyncopeUser user = null;
        String username = authentication.getPrincipal().toString();
        if (this.adminUser.equals(username)) {
            passwordUser.setPassword(authentication.getCredentials().toString(), CipherAlgorithm.MD5, 0);
            authenticated = this.adminMD5Password.equalsIgnoreCase(passwordUser.getPassword());
        } else {
            user = this.userDAO.find(username);
            if (user != null) {
                if (user.getSuspended().booleanValue()) {
                    throw new DisabledException("User " + user.getUsername() + " is suspended");
                }
                passwordUser.setPassword(authentication.getCredentials().toString(), user.getCipherAlgoritm(), 0);
                authenticated = user.getPassword().equalsIgnoreCase(passwordUser.getPassword());
            }
        }
        if (authenticated) {
            token = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), null, this.userDetailsService.loadUserByUsername(authentication.getPrincipal().toString()).getAuthorities());
            token.setDetails(authentication.getDetails());
            this.auditManager.audit(AuditElements.Category.authentication, (Enum<?>)AuditElements.AuthenticationSubCategory.login, AuditElements.Result.success, "Successfully authenticated, with roles: " + token.getAuthorities());
            LOG.debug("User {} successfully authenticated, with roles {}", authentication.getPrincipal(), (Object)token.getAuthorities());
            if (user != null) {
                user.setLastLoginDate(new Date());
                user.setFailedLogins(0);
                this.userDAO.save(user);
            }
        } else {
            if (user != null) {
                user.setFailedLogins(user.getFailedLogins() + 1);
                this.userDAO.save(user);
            }
            this.auditManager.audit(AuditElements.Category.authentication, (Enum<?>)AuditElements.AuthenticationSubCategory.login, AuditElements.Result.failure, "User " + authentication.getPrincipal() + " not authenticated");
            LOG.debug("User {} not authenticated", authentication.getPrincipal());
            throw new BadCredentialsException("User " + authentication.getPrincipal() + " not authenticated");
        }
        return token;
    }

    public boolean supports(Class<? extends Object> type) {
        return type.equals(UsernamePasswordAuthenticationToken.class);
    }
}

