/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public class AsymmetricCipher {
    private static final String xform = "RSA/NONE/PKCS1Padding";
    private static final String algorithm = "RSA";

    public static byte[] encrypt(byte[] inpBytes, PublicKey key) throws Exception {
        Cipher cipher = Cipher.getInstance(xform);
        cipher.init(1, key);
        return cipher.doFinal(inpBytes);
    }

    public static byte[] decrypt(byte[] inpBytes, PrivateKey key) throws Exception {
        Cipher cipher = Cipher.getInstance(xform);
        cipher.init(2, key);
        return cipher.doFinal(inpBytes);
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        kpg.initialize(2048, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static byte[] serializeKeyPair(KeyPair keyPair) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(keyPair);
        oos.close();
        return baos.toByteArray();
    }

    public static KeyPair deserializeKeyPair(byte[] serializedKeyPair) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedKeyPair);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (KeyPair)ois.readObject();
    }
}

