/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.syncope.core.scheduling.AbstractTaskJob;
import org.apache.syncope.types.TraceLevel;

public class SyncResult {
    private String message;
    private AbstractTaskJob.Status status;
    private Operation operation;
    private Long userId;
    private String username;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public AbstractTaskJob.Status getStatus() {
        return this.status;
    }

    public void setStatus(AbstractTaskJob.Status status) {
        this.status = status;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation t) {
        this.operation = t;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public String getReportString(TraceLevel level) {
        if (level == TraceLevel.SUMMARY) {
            return null;
        }
        if (level == TraceLevel.FAILURES && this.status == AbstractTaskJob.Status.FAILURE) {
            return String.format("Failed %s (id/name): %d/%s with message: %s", new Object[]{this.operation, this.userId, this.username, this.message});
        }
        return String.format("%s %s (id/ name): %d/ %s %s", new Object[]{this.operation, this.status, this.userId, this.username, StringUtils.isEmpty((String)this.message) ? "" : "with message: " + this.message});
    }

    public static String reportSetOfSynchronizationResult(Collection<SyncResult> results, TraceLevel level) {
        StringBuilder sb = new StringBuilder();
        for (SyncResult sr : results) {
            sb.append(sr.getReportString(level)).append("\n");
        }
        return sb.toString();
    }

    static enum Operation {
        CREATE,
        UPDATE,
        DELETE;

    }
}

