/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.search.AttributeCond;
import org.apache.syncope.client.search.NodeCond;
import org.apache.syncope.client.search.SyncopeUserCond;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.notification.NotificationManager;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.beans.user.UAttrValue;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.UserSearchDAO;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.propagation.PropagationException;
import org.apache.syncope.core.propagation.PropagationManager;
import org.apache.syncope.core.rest.controller.InvalidSearchConditionException;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.scheduling.AbstractTaskJob;
import org.apache.syncope.core.scheduling.SyncJobActions;
import org.apache.syncope.core.scheduling.SyncResult;
import org.apache.syncope.core.util.ConnObjectUtil;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.core.util.SchemaMappingUtil;
import org.apache.syncope.core.workflow.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.ConflictResolutionAction;
import org.apache.syncope.types.SyncPolicySpec;
import org.apache.syncope.types.TraceLevel;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class SyncJob
extends AbstractTaskJob {
    @Autowired
    private ConnInstanceLoader connInstanceLoader;
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserSearchDAO userSearchDAO;
    @Autowired
    private EntitlementDAO entitlementDAO;
    @Autowired
    private UserWorkflowAdapter wfAdapter;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private UserDataBinder userDataBinder;
    private SyncJobActions actions;
    @Autowired
    private ConnObjectUtil connObjectUtil;
    @Autowired
    private NotificationManager notificationManager;

    public void setActions(SyncJobActions actions) {
        this.actions = actions;
    }

    private List<Long> findExistingUsers(SyncDelta delta) {
        SyncTask syncTask = (SyncTask)this.task;
        String uid = delta.getPreviousUid() == null ? delta.getUid().getUidValue() : delta.getPreviousUid().getUidValue();
        SyncPolicy policy = syncTask.getResource().getSyncPolicy();
        SyncPolicySpec policySpec = policy != null ? (SyncPolicySpec)policy.getSpecification() : null;
        ArrayList<Long> result = new ArrayList<Long>();
        if (policySpec != null && !policySpec.getAlternativeSearchAttrs().isEmpty()) {
            ConnectorObject object = delta.getObject();
            HashMap<String, Attribute> extValues = new HashMap<String, Attribute>();
            for (SchemaMapping mapping : syncTask.getResource().getMappings()) {
                extValues.put(SchemaMappingUtil.getIntAttrName(mapping), object.getAttributeByName(SchemaMappingUtil.getExtAttrName(mapping)));
            }
            NodeCond searchCondition = null;
            for (String schema : policySpec.getAlternativeSearchAttrs()) {
                NodeCond nodeCond;
                SyncopeUserCond cond;
                AttributeCond.Type type;
                Attribute value = (Attribute)extValues.get(schema);
                String expression = null;
                if (value == null || value.getValue() == null || value.getValue().isEmpty()) {
                    type = AttributeCond.Type.ISNULL;
                } else {
                    type = AttributeCond.Type.EQ;
                    String string = expression = value.getValue().size() > 1 ? value.getValue().toString() : value.getValue().get(0).toString();
                }
                if ("id".equalsIgnoreCase(schema) || "username".equalsIgnoreCase(schema)) {
                    cond = new SyncopeUserCond();
                    cond.setSchema(schema);
                    cond.setType(type);
                    cond.setExpression(expression);
                    nodeCond = NodeCond.getLeafCond((SyncopeUserCond)cond);
                } else {
                    cond = new AttributeCond();
                    cond.setSchema(schema);
                    cond.setType(type);
                    cond.setExpression(expression);
                    nodeCond = NodeCond.getLeafCond((AttributeCond)cond);
                }
                searchCondition = searchCondition != null ? NodeCond.getAndCond((NodeCond)searchCondition, (NodeCond)nodeCond) : nodeCond;
            }
            List<SyncopeUser> users = this.userSearchDAO.search(EntitlementUtil.getRoleIds(this.entitlementDAO.findAll()), searchCondition);
            for (SyncopeUser user : users) {
                result.add(user.getId());
            }
        } else {
            SchemaMapping accountIdMap = SchemaMappingUtil.getAccountIdMapping(syncTask.getResource().getMappings());
            switch (accountIdMap.getIntMappingType()) {
                case Username: {
                    SyncopeUser found = this.userDAO.find(uid);
                    if (found != null) {
                        result.add(found.getId());
                    }
                    break;
                }
                case SyncopeUserId: {
                    SyncopeUser found = this.userDAO.find(Long.parseLong(uid));
                    if (found != null) {
                        result.add(found.getId());
                    }
                    break;
                }
                case UserSchema: {
                    UAttrValue value = new UAttrValue();
                    value.setStringValue(uid);
                    List<SyncopeUser> users = this.userDAO.findByAttrValue(accountIdMap.getIntAttrName(), value);
                    for (SyncopeUser user : users) {
                        result.add(user.getId());
                    }
                    break;
                }
                case UserDerivedSchema: {
                    try {
                        List<SyncopeUser> users = this.userDAO.findByDerAttrValue(accountIdMap.getIntAttrName(), uid);
                        for (SyncopeUser user : users) {
                            result.add(user.getId());
                        }
                        break;
                    }
                    catch (InvalidSearchConditionException e) {
                        LOG.error("Could not search for matching users", (Throwable)e);
                        break;
                    }
                }
                default: {
                    LOG.error("Invalid accountId type '{}'", (Object)accountIdMap.getIntMappingType());
                }
            }
        }
        return result;
    }

    private SyncResult createUser(SyncDelta delta, boolean dryRun) throws JobExecutionException {
        SyncResult result = new SyncResult();
        result.setOperation(SyncResult.Operation.CREATE);
        UserTO userTO = this.connObjectUtil.getUserTO(delta.getObject(), (SyncTask)this.task);
        delta = this.actions.beforeCreate(delta, userTO);
        if (dryRun) {
            result.setUserId(0L);
            result.setUsername(userTO.getUsername());
            result.setStatus(AbstractTaskJob.Status.SUCCESS);
        } else {
            try {
                Attribute status;
                Boolean enabled = null;
                if (((SyncTask)this.task).isSyncStatus() && (status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, (Set)delta.getObject().getAttributes())) != null) {
                    enabled = status.getValue() != null && !status.getValue().isEmpty() ? (Boolean)status.getValue().get(0) : null;
                }
                WorkflowResult<Map.Entry<Long, Boolean>> created = this.wfAdapter.create(userTO, true, enabled);
                List<PropagationTask> tasks = this.propagationManager.getCreateTaskIds(created, userTO.getPassword(), userTO.getVirtualAttributes(), Collections.singleton(((SyncTask)this.task).getResource().getName()));
                this.propagationManager.execute(tasks);
                this.notificationManager.createTasks(new WorkflowResult<Long>(created.getResult().getKey(), created.getPropByRes(), created.getPerformedTasks()));
                userTO = this.userDataBinder.getUserTO(created.getResult().getKey());
                result.setUserId(created.getResult().getKey());
                result.setUsername(userTO.getUsername());
                result.setStatus(AbstractTaskJob.Status.SUCCESS);
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate user " + delta.getUid().getUidValue(), (Throwable)e);
            }
            catch (Exception e) {
                result.setStatus(AbstractTaskJob.Status.FAILURE);
                result.setMessage(e.getMessage());
                LOG.error("Could not create user " + delta.getUid().getUidValue(), (Throwable)e);
            }
        }
        this.actions.after(delta, userTO, result);
        return result;
    }

    private void updateUsers(SyncDelta delta, List<Long> users, boolean dryRun, List<SyncResult> results) throws JobExecutionException {
        if (!((SyncTask)this.task).isPerformUpdate()) {
            LOG.debug("SyncTask not configured for update");
            return;
        }
        LOG.debug("About to update {}", users);
        for (Long userId : users) {
            SyncResult result = new SyncResult();
            result.setOperation(SyncResult.Operation.UPDATE);
            try {
                UserTO userTO = this.userDataBinder.getUserTO(userId);
                try {
                    UserMod userMod = this.connObjectUtil.getUserMod(userId, delta.getObject(), (SyncTask)this.task);
                    delta = this.actions.beforeUpdate(delta, userTO, userMod);
                    result.setStatus(AbstractTaskJob.Status.SUCCESS);
                    result.setUserId(userMod.getId());
                    result.setUsername(userMod.getUsername());
                    if (!dryRun) {
                        WorkflowResult<Map.Entry<Long, Boolean>> updated = this.wfAdapter.update(userMod);
                        List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(updated, userMod.getPassword(), userMod.getVirtualAttributesToBeRemoved(), userMod.getVirtualAttributesToBeUpdated(), Collections.singleton(((SyncTask)this.task).getResource().getName()));
                        this.propagationManager.execute(tasks);
                        this.notificationManager.createTasks(new WorkflowResult<Long>(updated.getResult().getKey(), updated.getPropByRes(), updated.getPerformedTasks()));
                        userTO = this.userDataBinder.getUserTO(updated.getResult().getKey());
                    }
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate user " + delta.getUid().getUidValue(), (Throwable)e);
                }
                catch (Exception e) {
                    result.setStatus(AbstractTaskJob.Status.FAILURE);
                    result.setMessage(e.getMessage());
                    LOG.error("Could not update user " + delta.getUid().getUidValue(), (Throwable)e);
                }
                this.actions.after(delta, userTO, result);
                results.add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find user {}", (Object)userId, (Object)e);
            }
            catch (UnauthorizedRoleException e) {
                LOG.error("Not allowed to read user {}", (Object)userId, (Object)e);
            }
        }
    }

    private void deleteUsers(SyncDelta delta, List<Long> users, boolean dryRun, List<SyncResult> results) throws JobExecutionException {
        if (!((SyncTask)this.task).isPerformDelete()) {
            LOG.debug("SyncTask not configured for delete");
            return;
        }
        LOG.debug("About to delete {}", users);
        for (Long userId : users) {
            try {
                UserTO userTO = this.userDataBinder.getUserTO(userId);
                delta = this.actions.beforeDelete(delta, userTO);
                SyncResult result = new SyncResult();
                result.setUserId(userId);
                result.setUsername(userTO.getUsername());
                result.setOperation(SyncResult.Operation.DELETE);
                result.setStatus(AbstractTaskJob.Status.SUCCESS);
                if (!dryRun) {
                    try {
                        List<PropagationTask> tasks = this.propagationManager.getDeleteTaskIds(userId, ((SyncTask)this.task).getResource().getName());
                        this.propagationManager.execute(tasks);
                        this.notificationManager.createTasks(new WorkflowResult<Long>(userId, null, "delete"));
                    }
                    catch (Exception e) {
                        LOG.error("Could not propagate user " + userId, (Throwable)e);
                    }
                    try {
                        this.wfAdapter.delete(userId);
                    }
                    catch (Exception e) {
                        result.setStatus(AbstractTaskJob.Status.FAILURE);
                        result.setMessage(e.getMessage());
                        LOG.error("Could not delete user " + userId, (Throwable)e);
                    }
                }
                this.actions.after(delta, userTO, result);
                results.add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find user {}", (Object)userId, (Object)e);
            }
            catch (UnauthorizedRoleException e) {
                LOG.error("Not allowed to read user {}", (Object)userId, (Object)e);
            }
        }
    }

    private String createReport(List<SyncResult> syncResults, TraceLevel syncTraceLevel, boolean dryRun) {
        if (syncTraceLevel == TraceLevel.NONE) {
            return null;
        }
        StringBuilder report = new StringBuilder();
        if (dryRun) {
            report.append("==>Dry run only, no modifications were made<==\n\n");
        }
        ArrayList<SyncResult> created = new ArrayList<SyncResult>();
        ArrayList<SyncResult> createdFailed = new ArrayList<SyncResult>();
        ArrayList<SyncResult> updated = new ArrayList<SyncResult>();
        ArrayList<SyncResult> updatedFailed = new ArrayList<SyncResult>();
        ArrayList<SyncResult> deleted = new ArrayList<SyncResult>();
        ArrayList<SyncResult> deletedFailed = new ArrayList<SyncResult>();
        for (SyncResult syncResult : syncResults) {
            block0 : switch (syncResult.getStatus()) {
                case SUCCESS: {
                    switch (syncResult.getOperation()) {
                        case CREATE: {
                            created.add(syncResult);
                            break block0;
                        }
                        case UPDATE: {
                            updated.add(syncResult);
                            break block0;
                        }
                        case DELETE: {
                            deleted.add(syncResult);
                            break block0;
                        }
                    }
                    break;
                }
                case FAILURE: {
                    switch (syncResult.getOperation()) {
                        case CREATE: {
                            createdFailed.add(syncResult);
                            break block0;
                        }
                        case UPDATE: {
                            updatedFailed.add(syncResult);
                            break block0;
                        }
                        case DELETE: {
                            deletedFailed.add(syncResult);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        report.append("Users [created/failures]: ").append(created.size()).append('/').append(createdFailed.size()).append(' ').append("[updated/failures]: ").append(updated.size()).append('/').append(updatedFailed.size()).append(' ').append("[deleted/ failures]: ").append(deleted.size()).append('/').append(deletedFailed.size());
        if (syncTraceLevel == TraceLevel.FAILURES || syncTraceLevel == TraceLevel.ALL) {
            if (!createdFailed.isEmpty()) {
                report.append("\n\nFailed to create: ");
                report.append(SyncResult.reportSetOfSynchronizationResult(createdFailed, syncTraceLevel));
            }
            if (!updatedFailed.isEmpty()) {
                report.append("\nFailed to update: ");
                report.append(SyncResult.reportSetOfSynchronizationResult(updatedFailed, syncTraceLevel));
            }
            if (!deletedFailed.isEmpty()) {
                report.append("\nFailed to delete: ");
                report.append(SyncResult.reportSetOfSynchronizationResult(deletedFailed, syncTraceLevel));
            }
        }
        if (syncTraceLevel == TraceLevel.ALL) {
            report.append("\n\nCreated:\n").append(SyncResult.reportSetOfSynchronizationResult(created, syncTraceLevel)).append("\nUpdated:\n").append(SyncResult.reportSetOfSynchronizationResult(updated, syncTraceLevel)).append("\nDeleted:\n").append(SyncResult.reportSetOfSynchronizationResult(deleted, syncTraceLevel));
        }
        return report.toString();
    }

    private void setupSecurity() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (Entitlement entitlement : this.entitlementDAO.findAll()) {
            authorities.add(new SimpleGrantedAuthority(entitlement.getName()));
        }
        User userDetails = new User("admin", "FAKE_PASSWORD", true, true, true, true, authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"FAKE_PASSWORD", authorities));
    }

    @Override
    protected String doExecute(final boolean dryRun) throws JobExecutionException {
        ArrayList<SyncResult> results;
        SyncTask syncTask;
        block11: {
            ConnectorFacadeProxy connector;
            if (EntitlementUtil.getOwnedEntitlementNames().isEmpty()) {
                this.setupSecurity();
            }
            if (!(this.task instanceof SyncTask)) {
                throw new JobExecutionException("Task " + this.taskId + " isn't a SyncTask");
            }
            syncTask = (SyncTask)this.task;
            try {
                connector = this.connInstanceLoader.getConnector(syncTask.getResource());
            }
            catch (Exception e) {
                String msg = String.format("Connector instance bean for resource %s and connInstance %s not found", syncTask.getResource(), syncTask.getResource().getConnector());
                throw new JobExecutionException(msg, (Throwable)e);
            }
            SchemaMapping accountIdMap = SchemaMappingUtil.getAccountIdMapping(syncTask.getResource().getMappings());
            if (accountIdMap == null) {
                throw new JobExecutionException("Invalid account id mapping for resource " + syncTask.getResource());
            }
            LOG.debug("Execute synchronization with token {}", syncTask.getResource().getSyncToken() != null ? syncTask.getResource().getSyncToken().getValue() : null);
            results = new ArrayList<SyncResult>();
            this.actions.beforeAll(syncTask);
            try {
                ConflictResolutionAction conflictResolutionAction;
                SyncPolicy syncPolicy = syncTask.getResource().getSyncPolicy();
                ConflictResolutionAction conflictResolutionAction2 = conflictResolutionAction = syncPolicy != null && syncPolicy.getSpecification() != null ? ((SyncPolicySpec)syncPolicy.getSpecification()).getConflictResolutionAction() : ConflictResolutionAction.IGNORE;
                if (syncTask.isFullReconciliation()) {
                    connector.getAllObjects(ObjectClass.ACCOUNT, new SyncResultsHandler(){

                        public boolean handle(SyncDelta delta) {
                            try {
                                results.addAll(SyncJob.this.handleDelta(syncTask, delta, conflictResolutionAction, dryRun));
                                return true;
                            }
                            catch (JobExecutionException e) {
                                AbstractTaskJob.LOG.error("Reconciliation failed", (Throwable)e);
                                return false;
                            }
                        }
                    }, connector.getOperationOptions(syncTask.getResource()));
                } else {
                    connector.sync(syncTask.getResource().getSyncToken(), new SyncResultsHandler(){

                        public boolean handle(SyncDelta delta) {
                            try {
                                results.addAll(SyncJob.this.handleDelta(syncTask, delta, conflictResolutionAction, dryRun));
                                return true;
                            }
                            catch (JobExecutionException e) {
                                AbstractTaskJob.LOG.error("Synchronization failed", (Throwable)e);
                                return false;
                            }
                        }
                    }, connector.getOperationOptions(syncTask.getResource()));
                }
                if (dryRun || syncTask.isFullReconciliation()) break block11;
                try {
                    ExternalResource resource = this.resourceDAO.find(syncTask.getResource().getName());
                    resource.setSyncToken(connector.getLatestSyncToken());
                    this.resourceDAO.save(resource);
                }
                catch (Exception e) {
                    throw new JobExecutionException("While updating SyncToken", (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new JobExecutionException("While syncing on connector", (Throwable)e);
            }
        }
        this.actions.afterAll(syncTask, results);
        String result = this.createReport(results, syncTask.getResource().getSyncTraceLevel(), dryRun);
        LOG.debug("Sync result: {}", (Object)result);
        return result.toString();
    }

    protected final List<SyncResult> handleDelta(SyncTask syncTask, SyncDelta delta, ConflictResolutionAction conflictResolutionAction, boolean dryRun) throws JobExecutionException {
        ArrayList<SyncResult> results = new ArrayList<SyncResult>();
        LOG.debug("Process '{}' for '{}'", (Object)delta.getDeltaType(), (Object)delta.getUid().getUidValue());
        List<Long> users = this.findExistingUsers(delta);
        block0 : switch (delta.getDeltaType()) {
            case CREATE_OR_UPDATE: {
                if (users.isEmpty()) {
                    if (syncTask.isPerformCreate()) {
                        results.add(this.createUser(delta, dryRun));
                        break;
                    }
                    LOG.debug("SyncTask not configured for create");
                    break;
                }
                if (users.size() == 1) {
                    this.updateUsers(delta, users.subList(0, 1), dryRun, results);
                    break;
                }
                switch (conflictResolutionAction) {
                    case IGNORE: {
                        LOG.error("More than one match {}", users);
                        break block0;
                    }
                    case FIRSTMATCH: {
                        this.updateUsers(delta, users.subList(0, 1), dryRun, results);
                        break block0;
                    }
                    case LASTMATCH: {
                        this.updateUsers(delta, users.subList(users.size() - 1, users.size()), dryRun, results);
                        break block0;
                    }
                    case ALL: {
                        this.updateUsers(delta, users, dryRun, results);
                        break block0;
                    }
                }
                break;
            }
            case DELETE: {
                if (users.isEmpty()) {
                    LOG.debug("No match found for deletion");
                    break;
                }
                if (users.size() == 1) {
                    this.deleteUsers(delta, users, dryRun, results);
                    break;
                }
                switch (conflictResolutionAction) {
                    case IGNORE: {
                        LOG.error("More than one match {}", users);
                        break block0;
                    }
                    case FIRSTMATCH: {
                        this.deleteUsers(delta, users.subList(0, 1), dryRun, results);
                        break block0;
                    }
                    case LASTMATCH: {
                        this.deleteUsers(delta, users.subList(users.size() - 1, users.size()), dryRun, results);
                        break block0;
                    }
                    case ALL: {
                        this.deleteUsers(delta, users, dryRun, results);
                        break block0;
                    }
                }
                break;
            }
        }
        return results;
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec execution) {
        SyncTask syncTask = (SyncTask)this.task;
        return AbstractTaskJob.Status.valueOf(execution.getStatus()) == AbstractTaskJob.Status.FAILURE && syncTask.getResource().getSyncTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || syncTask.getResource().getSyncTraceLevel() == TraceLevel.ALL;
    }
}

