/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.util.Map;
import org.apache.syncope.core.init.JobInstanceLoader;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.dao.ReportDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringBeanJobFactory
extends org.springframework.scheduling.quartz.SpringBeanJobFactory {
    private String[] ignoredUnknownProperties;
    private SchedulerContext schedulerContext;

    public void setIgnoredUnknownProperties(String[] ignoredUnknownProperties) {
        String[] defensiveCopy = (String[])ignoredUnknownProperties.clone();
        super.setIgnoredUnknownProperties(defensiveCopy);
        this.ignoredUnknownProperties = defensiveCopy;
    }

    public void setSchedulerContext(SchedulerContext schedulerContext) {
        super.setSchedulerContext(schedulerContext);
        this.schedulerContext = schedulerContext;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job;
        BeanWrapper wrapper;
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.schedulerContext.get((Object)"applicationContext");
        if (!ctx.containsBean(bundle.getJobDetail().getName())) {
            Long reportId;
            Long taskId = JobInstanceLoader.getTaskIdFromJobName(bundle.getJobDetail().getName());
            if (taskId != null) {
                TaskDAO taskDAO = (TaskDAO)ctx.getBean(TaskDAO.class);
                SchedTask task = (SchedTask)taskDAO.find(taskId);
                JobInstanceLoader jobInstanceLoader = (JobInstanceLoader)ctx.getBean(JobInstanceLoader.class);
                jobInstanceLoader.registerJob(task, task.getJobClassName(), task.getCronExpression());
            }
            if ((reportId = JobInstanceLoader.getReportIdFromJobName(bundle.getJobDetail().getName())) != null) {
                ReportDAO reportDAO = (ReportDAO)ctx.getBean(ReportDAO.class);
                Report report = reportDAO.find(reportId);
                JobInstanceLoader jobInstanceLoader = (JobInstanceLoader)ctx.getBean(JobInstanceLoader.class);
                jobInstanceLoader.registerJob(report);
            }
        }
        if (this.isEligibleForPropertyPopulation((wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)(job = ctx.getBean(bundle.getJobDetail().getName())))).getWrappedInstance())) {
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map)this.schedulerContext);
            }
            pvs.addPropertyValues((Map)bundle.getJobDetail().getJobDataMap());
            pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
            if (this.ignoredUnknownProperties == null) {
                wrapper.setPropertyValues((PropertyValues)pvs, true);
            } else {
                for (String propName : this.ignoredUnknownProperties) {
                    if (!pvs.contains(propName) || wrapper.isWritableProperty(propName)) continue;
                    pvs.removePropertyValue(propName);
                }
                wrapper.setPropertyValues((PropertyValues)pvs);
            }
        }
        return job;
    }
}

