/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.syncope.client.report.ReportletConf;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.ReportExec;
import org.apache.syncope.core.persistence.dao.ReportDAO;
import org.apache.syncope.core.persistence.dao.ReportExecDAO;
import org.apache.syncope.core.report.ReportException;
import org.apache.syncope.core.report.Reportlet;
import org.apache.syncope.core.rest.data.ReportDataBinder;
import org.apache.syncope.core.util.ApplicationContextProvider;
import org.apache.syncope.types.ReportExecStatus;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.xml.sax.helpers.AttributesImpl;

public class ReportJob
implements StatefulJob {
    private static final Logger LOG = LoggerFactory.getLogger(ReportJob.class);
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private ReportDataBinder dataBinder;
    private Long reportId;

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TransformerHandler handler;
        Report report = this.reportDAO.find(this.reportId);
        if (report == null) {
            throw new JobExecutionException("Report " + this.reportId + " not found");
        }
        ReportExec execution = new ReportExec();
        execution.setStatus(ReportExecStatus.STARTED);
        execution.setStartDate(new Date());
        execution.setReport(report);
        execution = this.reportExecDAO.save(execution);
        report.addExec(execution);
        report = this.reportDAO.save(report);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            handler = transformerFactory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            zos.putNextEntry(new ZipEntry(report.getName()));
            handler.setResult(new StreamResult(zos));
        }
        catch (Exception e) {
            throw new JobExecutionException("While configuring for SAX generation", (Throwable)e, true);
        }
        execution.setStatus(ReportExecStatus.RUNNING);
        execution = this.reportExecDAO.save(execution);
        ConfigurableListableBeanFactory beanFactory = ApplicationContextProvider.getApplicationContext().getBeanFactory();
        StringBuilder reportExecutionMessage = new StringBuilder();
        StringWriter exceptionWriter = new StringWriter();
        try {
            handler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "xsd:string", report.getName());
            handler.startElement("", "", "report", atts);
            for (ReportletConf reportletConf : report.getReportletConfs()) {
                Class<Reportlet> reportletClass = this.dataBinder.findReportletClassHavingConfClass(reportletConf.getClass());
                if (reportletClass == null) continue;
                Reportlet autowired = (Reportlet)beanFactory.createBean(reportletClass, 2, false);
                autowired.setConf(reportletConf);
                try {
                    autowired.extract(handler);
                }
                catch (Exception e) {
                    execution.setStatus(ReportExecStatus.FAILURE);
                    Throwable t = e instanceof ReportException ? e.getCause() : e;
                    exceptionWriter.write(t.getMessage() + "\n\n");
                    t.printStackTrace(new PrintWriter(exceptionWriter));
                    reportExecutionMessage.append(exceptionWriter.toString()).append("\n==================\n");
                }
            }
            handler.endElement("", "", "report");
            handler.endDocument();
            if (!ReportExecStatus.FAILURE.name().equals(execution.getStatus())) {
                execution.setStatus(ReportExecStatus.SUCCESS);
            }
        }
        catch (Exception e) {
            execution.setStatus(ReportExecStatus.FAILURE);
            exceptionWriter.write(e.getMessage() + "\n\n");
            e.printStackTrace(new PrintWriter(exceptionWriter));
            reportExecutionMessage.append(exceptionWriter.toString());
            throw new JobExecutionException((Throwable)e, true);
        }
        finally {
            try {
                zos.closeEntry();
                zos.close();
                baos.close();
            }
            catch (IOException e) {
                LOG.error("While closing StreamResult's backend", (Throwable)e);
            }
            execution.setExecResult(baos.toByteArray());
            execution.setMessage(reportExecutionMessage.toString());
            execution.setEndDate(new Date());
            this.reportExecDAO.save(execution);
        }
    }
}

