/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.notification.NotificationManager;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.TraceLevel;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class NotificationJob
implements StatefulJob {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationJob.class);
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private ConfDAO confDAO;
    private String smtpHost;
    private int smtpPort;
    private String smtpUsername;
    private String smtpPassword;

    private void init() {
        this.smtpHost = this.confDAO.find("smtp.host", "").getValue();
        this.smtpPort = 25;
        try {
            this.smtpPort = Integer.valueOf(this.confDAO.find("smtp.port", "25").getValue());
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid SMTP port, reverting to 25", (Throwable)e);
        }
        this.smtpUsername = this.confDAO.find("smtp.username", "").getValue();
        this.smtpPassword = this.confDAO.find("smtp.password", "").getValue();
        LOG.debug("SMTP details fetched: {}:{} / {}:[PASSWORD_NOT_SHOWN]", new Object[]{this.smtpHost, this.smtpPort, this.smtpUsername});
    }

    public TaskExec executeSingle(NotificationTask task) {
        this.init();
        TaskExec execution = new TaskExec();
        execution.setTask(task);
        execution.setStartDate(new Date());
        if (StringUtils.isBlank((String)this.smtpHost) || StringUtils.isBlank((String)task.getSender()) || StringUtils.isBlank((String)task.getSubject()) || task.getRecipients().isEmpty() || StringUtils.isBlank((String)task.getHtmlBody()) || StringUtils.isBlank((String)task.getTextBody())) {
            String message = "Could not fetch all required information for sending e-mails:\n" + this.smtpHost + ":" + this.smtpPort + "\n" + task.getRecipients() + "\n" + task.getSender() + "\n" + task.getSubject() + "\n" + task.getHtmlBody() + "\n" + task.getTextBody();
            LOG.error(message);
            execution.setStatus(Status.NOT_SENT.name());
            if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                execution.setMessage(message);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("About to send e-mails:\n" + this.smtpHost + ":" + this.smtpPort + "\n" + task.getRecipients() + "\n" + task.getSender() + "\n" + task.getSubject() + "\n" + task.getHtmlBody() + "\n" + task.getTextBody() + "\n");
            }
            for (String to : task.getRecipients()) {
                try {
                    JavaMailSenderImpl sender = new JavaMailSenderImpl();
                    sender.setHost(this.smtpHost);
                    sender.setPort(this.smtpPort);
                    sender.setDefaultEncoding("UTF-8");
                    if (StringUtils.isNotBlank((String)this.smtpUsername)) {
                        sender.setUsername(this.smtpUsername);
                    }
                    if (StringUtils.isNotBlank((String)this.smtpPassword)) {
                        sender.setPassword(this.smtpPassword);
                    }
                    MimeMessage message = sender.createMimeMessage();
                    MimeMessageHelper helper = new MimeMessageHelper(message, true);
                    helper.setTo(to);
                    helper.setFrom(task.getSender());
                    helper.setSubject(task.getSubject());
                    helper.setText(task.getTextBody(), task.getHtmlBody());
                    sender.send(message);
                    execution.setStatus(Status.SENT.name());
                    StringBuilder report = new StringBuilder();
                    switch (task.getTraceLevel()) {
                        case ALL: {
                            report.append("FROM: ").append(task.getSender()).append('\n').append("TO: ").append(to).append('\n').append("SUBJECT: ").append(task.getSubject()).append('\n').append('\n').append(task.getTextBody()).append('\n').append('\n').append(task.getHtmlBody()).append('\n');
                            break;
                        }
                        case SUMMARY: {
                            report.append("E-mail sent to ").append(to).append('\n');
                            break;
                        }
                    }
                    if (report.length() > 0) {
                        execution.setMessage(report.toString());
                    }
                    this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.sent, AuditElements.Result.success, "Successfully sent notification to " + to);
                }
                catch (Exception e) {
                    LOG.error("Could not send e-mail", (Throwable)e);
                    execution.setStatus(Status.NOT_SENT.name());
                    StringWriter exceptionWriter = new StringWriter();
                    exceptionWriter.write(e.getMessage() + "\n\n");
                    e.printStackTrace(new PrintWriter(exceptionWriter));
                    if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                        execution.setMessage(exceptionWriter.toString());
                    }
                    this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.sent, AuditElements.Result.failure, "Could not send notification to " + to, e);
                }
                execution.setEndDate(new Date());
            }
        }
        if (this.hasToBeRegistered(execution)) {
            execution = this.notificationManager.storeExec(execution);
        } else {
            this.notificationManager.setTaskExecuted(execution.getTask().getId());
        }
        return execution;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Waking up...");
        for (NotificationTask task : this.taskDAO.findToExec(NotificationTask.class)) {
            LOG.debug("Found notification task {} to be executed: starting...", (Object)task);
            this.executeSingle(task);
            LOG.debug("Notification task {} executed", (Object)task);
        }
        LOG.debug("Sleeping again...");
    }

    private boolean hasToBeRegistered(TaskExec execution) {
        NotificationTask task = (NotificationTask)execution.getTask();
        return Status.valueOf(execution.getStatus()) == Status.NOT_SENT && task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getTraceLevel() == TraceLevel.ALL;
    }

    static enum Status {
        SENT,
        NOT_SENT;

    }
}

