/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.scheduling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.TaskExecDAO;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTaskJob
implements StatefulJob {
    public static final String DRY_RUN_JOBDETAIL_KEY = "dryRun";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTaskJob.class);
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    protected Long taskId;
    protected Task task;

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public final void execute(JobExecutionContext context) throws JobExecutionException {
        this.task = this.taskDAO.find(this.taskId);
        if (this.task == null) {
            throw new JobExecutionException("Task " + this.taskId + " not found");
        }
        TaskExec execution = new TaskExec();
        execution.setStartDate(new Date());
        execution.setTask(this.task);
        try {
            execution.setMessage(this.doExecute(context.getMergedJobDataMap().getBoolean(DRY_RUN_JOBDETAIL_KEY)));
            execution.setStatus(Status.SUCCESS.name());
        }
        catch (JobExecutionException e) {
            LOG.error("While executing task " + this.taskId, (Throwable)e);
            StringWriter exceptionWriter = new StringWriter();
            exceptionWriter.write(e.getMessage() + "\n\n");
            e.printStackTrace(new PrintWriter(exceptionWriter));
            execution.setMessage(exceptionWriter.toString());
            execution.setStatus(Status.FAILURE.name());
        }
        execution.setEndDate(new Date());
        if (this.hasToBeRegistered(execution)) {
            this.taskExecDAO.saveAndAdd(this.taskId, execution);
        }
        this.task = this.taskDAO.save(this.task);
    }

    protected abstract String doExecute(boolean var1) throws JobExecutionException;

    protected boolean hasToBeRegistered(TaskExec execution) {
        return false;
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

