/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import javassist.NotFoundException;
import javax.persistence.RollbackException;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.UserRequestTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.persistence.beans.UserRequest;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserRequestDataBinder {
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private UserDAO userDAO;

    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public SyncopeUser getUserFromId(Long userId) throws NotFoundException, UnauthorizedRoleException {
        if (userId == null) {
            throw new NotFoundException("Null user id");
        }
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        SyncopeUser authUser = this.userDAO.find(SecurityContextHolder.getContext().getAuthentication().getName());
        if (authUser == null || !authUser.equals(user)) {
            throw new UnauthorizedRoleException(-1L);
        }
        return user;
    }

    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public UserTO getAuthUserTO() throws NotFoundException {
        SyncopeUser authUser = this.userDAO.find(SecurityContextHolder.getContext().getAuthentication().getName());
        return this.userDataBinder.getUserTO(authUser);
    }

    public UserRequestTO getUserRequestTO(UserRequest request) {
        UserRequestTO result = new UserRequestTO();
        BeanUtils.copyProperties((Object)request, (Object)result);
        return result;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void testCreate(UserTO userTO) {
        SyncopeUser user = new SyncopeUser();
        this.userDataBinder.create(user, userTO);
        this.userDAO.save(user);
        throw new RollbackException();
    }

    @Transactional(rollbackFor={Throwable.class})
    public void testUpdate(UserMod userMod) throws NotFoundException, UnauthorizedRoleException {
        SyncopeUser user = this.getUserFromId(userMod.getId());
        this.userDataBinder.update(user, userMod);
        this.userDAO.save(user);
        throw new RollbackException();
    }

    @Transactional(rollbackFor={Throwable.class})
    public void testDelete(Long userId) throws NotFoundException, UnauthorizedRoleException {
        SyncopeUser user = this.getUserFromId(userId);
        this.userDAO.delete(user);
        throw new RollbackException();
    }
}

