/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.mod.AbstractAttributableMod;
import org.apache.syncope.client.mod.MembershipMod;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.MembershipTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.membership.MAttr;
import org.apache.syncope.core.persistence.beans.membership.MDerAttr;
import org.apache.syncope.core.persistence.beans.membership.MVirAttr;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.AbstractAttributableDataBinder;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.core.util.ConnObjectUtil;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.types.AttributableType;
import org.apache.syncope.types.CipherAlgorithm;
import org.apache.syncope.types.IntMappingType;
import org.apache.syncope.types.PasswordPolicySpec;
import org.apache.syncope.types.PropagationOperation;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class UserDataBinder
extends AbstractAttributableDataBinder {
    private static final String[] IGNORE_USER_PROPERTIES = new String[]{"memberships", "attributes", "derivedAttributes", "virtualAttributes", "resources"};
    @Autowired
    private ConnObjectUtil connObjectUtil;

    @Transactional(readOnly=true)
    public SyncopeUser getUserFromId(Long userId) throws NotFoundException, UnauthorizedRoleException {
        if (userId == null) {
            throw new NotFoundException("Null user id");
        }
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        Set<Long> roleIds = user.getRoleIds();
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        roleIds.removeAll(adminRoleIds);
        if (!roleIds.isEmpty()) {
            throw new UnauthorizedRoleException(roleIds);
        }
        return user;
    }

    @Transactional(readOnly=true)
    public boolean verifyPassword(String username, String password) throws NotFoundException, UnauthorizedRoleException {
        SyncopeUser user = this.getUserFromUsername(username);
        SyncopeUser passwordUser = new SyncopeUser();
        passwordUser.setPassword(password, user.getCipherAlgoritm(), 0);
        return user.getPassword().equalsIgnoreCase(passwordUser.getPassword());
    }

    @Transactional(readOnly=true)
    public boolean verifyPassword(SyncopeUser user, String password) throws NotFoundException, UnauthorizedRoleException {
        SyncopeUser passwordUser = new SyncopeUser();
        passwordUser.setPassword(password, user.getCipherAlgoritm(), 0);
        return user.getPassword().equalsIgnoreCase(passwordUser.getPassword());
    }

    @Transactional(readOnly=true)
    public SyncopeUser getUserFromUsername(String username) throws NotFoundException, UnauthorizedRoleException {
        if (username == null) {
            throw new NotFoundException("Null username");
        }
        SyncopeUser user = this.userDAO.find(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        Set<Long> roleIds = user.getRoleIds();
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        roleIds.removeAll(adminRoleIds);
        if (!roleIds.isEmpty()) {
            throw new UnauthorizedRoleException(roleIds);
        }
        return user;
    }

    private CipherAlgorithm getCipherAlgoritm() {
        return CipherAlgorithm.valueOf((String)this.confDAO.find("password.cipher.algorithm", "AES").getValue());
    }

    public void create(SyncopeUser user, UserTO userTO) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            SyncopeRole role = this.roleDAO.find(membershipTO.getRoleId());
            if (role == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring invalid role " + membershipTO.getRoleName());
                continue;
            }
            Membership membership = null;
            if (user.getId() != null) {
                Membership membership2 = membership = user.getMembership(role.getId()) == null ? this.membershipDAO.find(user, role) : user.getMembership(role.getId());
            }
            if (membership == null) {
                membership = new Membership();
                membership.setSyncopeRole(role);
                membership.setSyncopeUser(user);
                user.addMembership(membership);
            }
            this.fill((AbstractAttributable)membership, (AbstractAttributableTO)membershipTO, AttributableUtil.getInstance(AttributableType.MEMBERSHIP), scce);
        }
        this.fill((AbstractAttributable)user, (AbstractAttributableTO)userTO, AttributableUtil.getInstance(AttributableType.USER), scce);
        int passwordHistorySize = 0;
        try {
            PasswordPolicy policy = this.policyDAO.getGlobalPasswordPolicy();
            PasswordPolicySpec passwordPolicy = (PasswordPolicySpec)policy.getSpecification();
            passwordHistorySize = passwordPolicy.getHistoryLength();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (userTO.getPassword() == null || userTO.getPassword().isEmpty()) {
            LOG.error("No password provided");
        } else {
            user.setPassword(userTO.getPassword(), this.getCipherAlgoritm(), passwordHistorySize);
        }
        user.setUsername(userTO.getUsername());
        user.setCreationDate(new Date());
    }

    public PropagationByResource update(SyncopeUser user, UserMod userMod) throws SyncopeClientCompositeErrorException {
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        Set<String> currentResources = user.getResourceNames();
        if (userMod.getPassword() != null) {
            int passwordHistorySize = 0;
            try {
                PasswordPolicy policy = this.policyDAO.getGlobalPasswordPolicy();
                PasswordPolicySpec passwordPolicy = (PasswordPolicySpec)policy.getSpecification();
                passwordHistorySize = passwordPolicy.getHistoryLength();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            user.setPassword(userMod.getPassword(), this.getCipherAlgoritm(), passwordHistorySize);
            user.setChangePwdDate(new Date());
            propByRes.addAll(PropagationOperation.UPDATE, currentResources);
        }
        if (userMod.getUsername() != null && !userMod.getUsername().equals(user.getUsername())) {
            String oldUsername = user.getUsername();
            user.setUsername(userMod.getUsername());
            propByRes.addAll(PropagationOperation.UPDATE, currentResources);
            for (ExternalResource resource : user.getResources()) {
                for (SchemaMapping mapping : resource.getMappings()) {
                    if (!mapping.isAccountid() || mapping.getIntMappingType() != IntMappingType.Username) continue;
                    propByRes.addOldAccountId(resource.getName(), oldUsername);
                }
            }
        }
        propByRes.merge(this.fill((AbstractAttributable)user, (AbstractAttributableMod)userMod, AttributableUtil.getInstance(AttributableType.USER), scce));
        HashSet<Long> membershipToBeAddedRoleIds = new HashSet<Long>();
        for (MembershipMod membToBeAdded : userMod.getMembershipsToBeAdded()) {
            membershipToBeAddedRoleIds.add(membToBeAdded.getRole());
        }
        HashSet<String> toBeDeprovisioned = new HashSet<String>();
        HashSet<String> toBeProvisioned = new HashSet<String>();
        Membership membership = null;
        for (Long membershipId : userMod.getMembershipsToBeRemoved()) {
            LOG.debug("Membership to be removed: {}", (Object)membershipId);
            membership = this.membershipDAO.find(membershipId);
            if (membership == null) {
                LOG.debug("Invalid membership id specified to be removed: {}", (Object)membershipId);
                continue;
            }
            if (!membershipToBeAddedRoleIds.contains(membership.getSyncopeRole().getId())) {
                toBeDeprovisioned.addAll(membership.getSyncopeRole().getResourceNames());
            }
            if (membershipToBeAddedRoleIds.contains((membership = user.getMembership(membership.getSyncopeRole().getId())).getSyncopeRole().getId())) {
                HashSet<Long> attributeIds = new HashSet<Long>(membership.getAttributes().size());
                for (AbstractAttr abstractAttr : membership.getAttributes()) {
                    attributeIds.add(abstractAttr.getId());
                }
                for (Long l : attributeIds) {
                    this.attributeDAO.delete(l, MAttr.class);
                }
                attributeIds.clear();
                for (AbstractDerAttr abstractDerAttr : membership.getDerivedAttributes()) {
                    attributeIds.add(abstractDerAttr.getId());
                }
                for (Long l : attributeIds) {
                    this.derAttrDAO.delete(l, MDerAttr.class);
                }
                attributeIds.clear();
                for (AbstractVirAttr abstractVirAttr : membership.getVirtualAttributes()) {
                    attributeIds.add(abstractVirAttr.getId());
                }
                for (Long l : attributeIds) {
                    this.virAttrDAO.delete(l, MVirAttr.class);
                }
                attributeIds.clear();
                continue;
            }
            user.removeMembership(membership);
            this.membershipDAO.delete(membershipId);
        }
        for (MembershipMod membershipMod : userMod.getMembershipsToBeAdded()) {
            LOG.debug("Membership to be added: role({})", (Object)membershipMod.getRole());
            SyncopeRole role = this.roleDAO.find(membershipMod.getRole());
            if (role == null) {
                LOG.debug("Ignoring invalid role {}", (Object)membershipMod.getRole());
                continue;
            }
            membership = user.getMembership(role.getId());
            if (membership == null) {
                membership = new Membership();
                membership.setSyncopeRole(role);
                membership.setSyncopeUser(user);
                user.addMembership(membership);
                toBeProvisioned.addAll(role.getResourceNames());
            }
            propByRes.merge(this.fill((AbstractAttributable)membership, (AbstractAttributableMod)membershipMod, AttributableUtil.getInstance(AttributableType.MEMBERSHIP), scce));
        }
        Set<String> updatedResources = user.getResourceNames();
        updatedResources.removeAll(currentResources);
        if (!updatedResources.isEmpty() && StringUtils.isBlank((String)userMod.getPassword())) {
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
            sce.addElement("password cannot be empty when subscribing to new resources");
            scce.addException(sce);
            throw scce;
        }
        propByRes.addAll(PropagationOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(PropagationOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(PropagationOperation.UPDATE, currentResources);
        }
        return propByRes;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(SyncopeUser user) {
        UserTO userTO = new UserTO();
        BeanUtils.copyProperties((Object)user, (Object)userTO, (String[])IGNORE_USER_PROPERTIES);
        this.connObjectUtil.retrieveVirAttrValues(user);
        this.fillTO((AbstractAttributableTO)userTO, user.getAttributes(), user.getDerivedAttributes(), user.getVirtualAttributes(), user.getResources());
        for (Membership membership : user.getMemberships()) {
            MembershipTO membershipTO = new MembershipTO();
            membershipTO.setId(membership.getId().longValue());
            membershipTO.setRoleId(membership.getSyncopeRole().getId().longValue());
            membershipTO.setRoleName(membership.getSyncopeRole().getName());
            this.fillTO((AbstractAttributableTO)membershipTO, membership.getAttributes(), membership.getDerivedAttributes(), membership.getVirtualAttributes(), membership.getResources());
            userTO.addMembership(membershipTO);
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String username) throws NotFoundException, UnauthorizedRoleException {
        return this.getUserTO(this.getUserFromUsername(username));
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(Long userId) throws NotFoundException, UnauthorizedRoleException {
        return this.getUserTO(this.getUserFromId(userId));
    }
}

