/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import javassist.NotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.client.to.MembershipTO;
import org.apache.syncope.client.to.PropagationTaskTO;
import org.apache.syncope.client.to.SchedTaskTO;
import org.apache.syncope.client.to.SyncTaskTO;
import org.apache.syncope.client.to.TaskExecTO;
import org.apache.syncope.client.to.TaskTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.init.JobInstanceLoader;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.TaskExecDAO;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.core.util.TaskUtil;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class TaskDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDataBinder.class);
    private static final String[] IGNORE_TASK_PROPERTIES = new String[]{"latestExecStatus", "executions", "resource", "user"};
    private static final String[] IGNORE_TASK_EXECUTION_PROPERTIES = new String[]{"id", "task"};
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private JexlUtil jexlUtil;

    private void checkJexl(AbstractAttributableTO attributableTO, SyncopeClientException sce) {
        for (AttributeTO attrTO : attributableTO.getAttributes()) {
            if (attrTO.getValues().isEmpty() || this.jexlUtil.isExpressionValid((String)attrTO.getValues().get(0))) continue;
            sce.addElement("Invalid JEXL: " + (String)attrTO.getValues().get(0));
        }
        for (AttributeTO attrTO : attributableTO.getVirtualAttributes()) {
            if (attrTO.getValues().isEmpty() || this.jexlUtil.isExpressionValid((String)attrTO.getValues().get(0))) continue;
            sce.addElement("Invalid JEXL: " + (String)attrTO.getValues().get(0));
        }
    }

    private void fill(SyncTask task, SyncTaskTO taskTO) {
        if (taskTO.getUserTemplate() != null) {
            UserTO template = taskTO.getUserTemplate();
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidSyncTask);
            if (StringUtils.isNotBlank((String)template.getUsername()) && !this.jexlUtil.isExpressionValid(template.getUsername())) {
                sce.addElement("Invalid JEXL: " + template.getUsername());
            }
            if (StringUtils.isNotBlank((String)template.getPassword()) && !this.jexlUtil.isExpressionValid(template.getPassword())) {
                sce.addElement("Invalid JEXL: " + template.getPassword());
            }
            this.checkJexl((AbstractAttributableTO)template, sce);
            for (MembershipTO memb : template.getMemberships()) {
                this.checkJexl((AbstractAttributableTO)memb, sce);
            }
            if (!sce.isEmpty()) {
                SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
                scce.addException(sce);
                throw scce;
            }
        }
        task.setUserTemplate(taskTO.getUserTemplate());
        task.setPerformCreate(taskTO.isPerformCreate());
        task.setPerformUpdate(taskTO.isPerformUpdate());
        task.setPerformDelete(taskTO.isPerformDelete());
        task.setSyncStatus(taskTO.isSyncStatus());
        task.setFullReconciliation(taskTO.isFullReconciliation());
        task.setJobActionsClassName(taskTO.getJobActionsClassName());
    }

    public SchedTask createSchedTask(SchedTaskTO taskTO, TaskUtil taskUtil) throws NotFoundException {
        SchedTask task = (SchedTask)taskUtil.newTask();
        task.setCronExpression(taskTO.getCronExpression());
        switch (taskUtil) {
            case SCHED: {
                task.setJobClassName(taskTO.getJobClassName());
                break;
            }
            case SYNC: {
                if (!(taskTO instanceof SyncTaskTO)) {
                    throw new ClassCastException("taskUtil is type SyncTask but taskTO is not SyncTaskTO: " + taskTO.getClass().getName());
                }
                SyncTaskTO syncTaskTO = (SyncTaskTO)taskTO;
                ExternalResource resource = this.resourceDAO.find(syncTaskTO.getResource());
                if (resource == null) {
                    throw new NotFoundException("Resource " + syncTaskTO.getResource());
                }
                ((SyncTask)task).setResource(resource);
                this.fill((SyncTask)task, syncTaskTO);
            }
        }
        return task;
    }

    public void updateSchedTask(SchedTask task, SchedTaskTO taskTO, TaskUtil taskUtil) {
        task.setCronExpression(taskTO.getCronExpression());
        if (taskUtil == TaskUtil.SYNC) {
            if (!(task instanceof SyncTask)) {
                throw new ClassCastException("taskUtil is type SyncTask but task is not SyncTask: " + task.getClass().getName());
            }
            if (!(taskTO instanceof SyncTaskTO)) {
                throw new ClassCastException("taskUtil is type SyncTask but taskTO is not SyncTaskTO: " + taskTO.getClass().getName());
            }
            this.fill((SyncTask)task, (SyncTaskTO)taskTO);
        }
    }

    public TaskExecTO getTaskExecTO(TaskExec execution) {
        TaskExecTO executionTO = new TaskExecTO();
        BeanUtils.copyProperties((Object)execution, (Object)executionTO, (String[])IGNORE_TASK_EXECUTION_PROPERTIES);
        if (execution.getId() != null) {
            executionTO.setId(execution.getId().longValue());
        }
        if (execution.getTask() != null && execution.getTask().getId() != null) {
            executionTO.setTask(execution.getTask().getId().longValue());
        }
        return executionTO;
    }

    private void setExecTime(SchedTaskTO taskTO, Task task) {
        Trigger trigger;
        String triggerName = JobInstanceLoader.getTriggerName(JobInstanceLoader.getJobName(task));
        try {
            trigger = this.scheduler.getScheduler().getTrigger(triggerName, "DEFAULT");
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
            trigger = null;
        }
        if (trigger != null) {
            taskTO.setLastExec(trigger.getPreviousFireTime());
            taskTO.setNextExec(trigger.getNextFireTime());
        }
    }

    public TaskTO getTaskTO(Task task, TaskUtil taskUtil) {
        Object taskTO = taskUtil.newTaskTO();
        BeanUtils.copyProperties((Object)task, taskTO, (String[])IGNORE_TASK_PROPERTIES);
        TaskExec latestExec = this.taskExecDAO.findLatestStarted(task);
        taskTO.setLatestExecStatus(latestExec == null ? "" : latestExec.getStatus());
        taskTO.setStartDate(latestExec == null ? null : latestExec.getStartDate());
        taskTO.setEndDate(latestExec == null ? null : latestExec.getEndDate());
        for (TaskExec execution : task.getExecs()) {
            taskTO.addExecution(this.getTaskExecTO(execution));
        }
        switch (taskUtil) {
            case PROPAGATION: {
                if (!(task instanceof PropagationTask)) {
                    throw new ClassCastException("taskUtil is type Propagation but task is not PropagationTask: " + task.getClass().getName());
                }
                ((PropagationTaskTO)taskTO).setResource(((PropagationTask)task).getResource().getName());
                if (((PropagationTask)task).getSyncopeUser() == null) break;
                ((PropagationTaskTO)taskTO).setUser(((PropagationTask)task).getSyncopeUser().getId().longValue());
                break;
            }
            case SCHED: {
                this.setExecTime((SchedTaskTO)taskTO, task);
                break;
            }
            case SYNC: {
                this.setExecTime((SchedTaskTO)taskTO, task);
                if (!(task instanceof SyncTask)) {
                    throw new ClassCastException("taskUtil is type Sync but task is not SyncTask: " + task.getClass().getName());
                }
                ((SyncTaskTO)taskTO).setResource(((SyncTask)task).getResource().getName());
                break;
            }
            case NOTIFICATION: {
                if (!((NotificationTask)task).isExecuted() || !StringUtils.isBlank((String)taskTO.getLatestExecStatus())) break;
                taskTO.setLatestExecStatus("[EXECUTED]");
                break;
            }
        }
        return taskTO;
    }
}

