/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.List;
import org.apache.syncope.client.to.SchemaTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class SchemaDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaDataBinder.class);
    private static final String[] IGNORE_SCHEMA_PROPERTIES = new String[]{"derivedSchemas", "attributes"};
    @Autowired
    private SchemaDAO schemaDAO;
    @Autowired
    private JexlUtil jexlUtil;

    private <T extends AbstractDerSchema> void populate(AbstractSchema schema, SchemaTO schemaTO) throws SyncopeClientCompositeErrorException {
        if (!this.jexlUtil.isExpressionValid(schemaTO.getMandatoryCondition())) {
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException invalidMandatoryCondition = new SyncopeClientException(SyncopeClientExceptionType.InvalidValues);
            invalidMandatoryCondition.addElement(schemaTO.getMandatoryCondition());
            scce.addException(invalidMandatoryCondition);
            throw scce;
        }
        BeanUtils.copyProperties((Object)schemaTO, (Object)schema, (String[])IGNORE_SCHEMA_PROPERTIES);
    }

    public void create(SchemaTO schemaTO, AbstractSchema schema) throws SyncopeClientCompositeErrorException {
        this.populate(schema, schemaTO);
    }

    public void update(SchemaTO schemaTO, AbstractSchema schema, AttributableUtil attributableUtil) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        List attrs = this.schemaDAO.getAttributes(schema, attributableUtil.attributeClass());
        if (!attrs.isEmpty()) {
            SyncopeClientException e;
            if (schema.getType() != schemaTO.getType()) {
                e = new SyncopeClientException(SyncopeClientExceptionType.valueOf((String)("Invalid" + schema.getClass().getSimpleName())));
                e.addElement("Cannot change type since " + schema.getName() + " has attributes");
                scce.addException(e);
            }
            if (schema.isUniqueConstraint() != schemaTO.isUniqueConstraint()) {
                e = new SyncopeClientException(SyncopeClientExceptionType.valueOf((String)("Invalid" + schema.getClass().getSimpleName())));
                e.addElement("Cannot alter unique contraint since " + schema.getName() + " has attributes");
                scce.addException(e);
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        this.populate(schema, schemaTO);
    }

    public <T extends AbstractSchema> SchemaTO getSchemaTO(T schema, AttributableUtil attributableUtil) {
        SchemaTO schemaTO = new SchemaTO();
        BeanUtils.copyProperties(schema, (Object)schemaTO, (String[])IGNORE_SCHEMA_PROPERTIES);
        return schemaTO;
    }
}

