/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.List;
import org.apache.syncope.client.mod.AbstractAttributableMod;
import org.apache.syncope.client.mod.RoleMod;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.RoleTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.role.RAttr;
import org.apache.syncope.core.persistence.beans.role.RDerAttr;
import org.apache.syncope.core.persistence.beans.role.RVirAttr;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.rest.data.AbstractAttributableDataBinder;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.types.AttributableType;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class RoleDataBinder
extends AbstractAttributableDataBinder {
    @Autowired
    private EntitlementDAO entitlementDAO;

    public SyncopeRole create(RoleTO roleTO) throws SyncopeClientCompositeErrorException {
        SyncopeRole otherRole;
        SyncopeRole role = new SyncopeRole();
        role.setInheritAttributes(roleTO.isInheritAttributes());
        role.setInheritDerivedAttributes(roleTO.isInheritDerivedAttributes());
        role.setInheritVirtualAttributes(roleTO.isInheritVirtualAttributes());
        role.setInheritPasswordPolicy(roleTO.isInheritPasswordPolicy());
        role.setInheritAccountPolicy(roleTO.isInheritAccountPolicy());
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException invalidRoles = new SyncopeClientException(SyncopeClientExceptionType.InvalidRoles);
        if (roleTO.getName() == null) {
            LOG.error("No name specified for this role");
            invalidRoles.addElement("No name specified for this role");
        } else {
            role.setName(roleTO.getName());
        }
        Long parentRoleId = null;
        if (roleTO.getParent() != 0L) {
            SyncopeRole parentRole = this.roleDAO.find(roleTO.getParent());
            if (parentRole == null) {
                LOG.error("Could not find role with id " + roleTO.getParent());
                invalidRoles.addElement(String.valueOf(roleTO.getParent()));
                scce.addException(invalidRoles);
            } else {
                role.setParent(parentRole);
                parentRoleId = role.getParent().getId();
            }
        }
        if ((otherRole = this.roleDAO.find(roleTO.getName(), parentRoleId)) != null) {
            LOG.error("Another role exists with the same name and the same parent role: " + otherRole);
            invalidRoles.addElement(roleTO.getName());
        }
        this.fill((AbstractAttributable)role, (AbstractAttributableTO)roleTO, AttributableUtil.getInstance(AttributableType.ROLE), scce);
        for (String entitlementName : roleTO.getEntitlements()) {
            Entitlement entitlement = this.entitlementDAO.find(entitlementName);
            if (entitlement == null) {
                LOG.warn("Ignoring invalid entitlement {}", (Object)entitlementName);
                continue;
            }
            role.addEntitlement(entitlement);
        }
        role.setPasswordPolicy(roleTO.getPasswordPolicy() != null ? (PasswordPolicy)this.policyDAO.find(roleTO.getPasswordPolicy()) : null);
        role.setAccountPolicy(roleTO.getAccountPolicy() != null ? (AccountPolicy)this.policyDAO.find(roleTO.getAccountPolicy()) : null);
        return role;
    }

    public PropagationByResource update(SyncopeRole role, RoleMod roleMod) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException invalidRoles = new SyncopeClientException(SyncopeClientExceptionType.InvalidRoles);
        if (roleMod.getName() != null) {
            SyncopeRole otherRole = this.roleDAO.find(roleMod.getName(), role.getParent() != null ? role.getParent().getId() : 0L);
            if (otherRole != null) {
                LOG.error("Another role exists with the same name and the same parent role: " + otherRole);
                invalidRoles.addElement(roleMod.getName());
                scce.addException(invalidRoles);
            } else {
                role.setName(roleMod.getName());
            }
        }
        if (roleMod.getInheritAttributes() != null) {
            role.setInheritAttributes(roleMod.getInheritAttributes());
        }
        if (roleMod.getInheritDerivedAttributes() != null) {
            role.setInheritDerivedAttributes(roleMod.getInheritDerivedAttributes());
        }
        if (roleMod.getInheritVirtualAttributes() != null) {
            role.setInheritVirtualAttributes(roleMod.getInheritVirtualAttributes());
        }
        if (roleMod.getInheritPasswordPolicy() != null) {
            role.setInheritPasswordPolicy(roleMod.getInheritPasswordPolicy());
        }
        if (roleMod.getInheritAccountPolicy() != null) {
            role.setInheritAccountPolicy(roleMod.getInheritAccountPolicy());
        }
        role.getEntitlements().clear();
        for (String entitlementName : roleMod.getEntitlements()) {
            Entitlement entitlement = this.entitlementDAO.find(entitlementName);
            if (entitlement == null) {
                LOG.warn("Ignoring invalid entitlement {}", (Object)entitlementName);
                continue;
            }
            role.addEntitlement(entitlement);
        }
        if (roleMod.getPasswordPolicy() != null) {
            role.setPasswordPolicy(roleMod.getPasswordPolicy().getId() != null ? (PasswordPolicy)this.policyDAO.find(roleMod.getPasswordPolicy().getId()) : null);
        }
        if (roleMod.getAccountPolicy() != null) {
            role.setAccountPolicy(roleMod.getAccountPolicy().getId() != null ? (AccountPolicy)this.policyDAO.find(roleMod.getAccountPolicy().getId()) : null);
        }
        return this.fill((AbstractAttributable)role, (AbstractAttributableMod)roleMod, AttributableUtil.getInstance(AttributableType.ROLE), scce);
    }

    public RoleTO getRoleTO(SyncopeRole role) {
        RoleTO roleTO = new RoleTO();
        roleTO.setId(role.getId().longValue());
        roleTO.setName(role.getName());
        roleTO.setInheritAttributes(role.isInheritAttributes());
        roleTO.setInheritDerivedAttributes(role.isInheritDerivedAttributes());
        roleTO.setInheritVirtualAttributes(role.isInheritVirtualAttributes());
        roleTO.setInheritPasswordPolicy(role.isInheritPasswordPolicy());
        roleTO.setInheritAccountPolicy(role.isInheritAccountPolicy());
        if (role.getParent() != null) {
            roleTO.setParent(role.getParent().getId().longValue());
        }
        List<RAttr> allAttributes = role.findInheritedAttributes();
        allAttributes.addAll(role.getAttributes());
        List<RDerAttr> allDerAttributes = role.findInheritedDerivedAttributes();
        allDerAttributes.addAll(role.getDerivedAttributes());
        List<RVirAttr> allVirAttributes = role.findInheritedVirtualAttributes();
        allVirAttributes.addAll(role.getVirtualAttributes());
        this.fillTO((AbstractAttributableTO)roleTO, allAttributes, allDerAttributes, allVirAttributes, role.getResources());
        for (Entitlement entitlement : role.getEntitlements()) {
            roleTO.addEntitlement(entitlement.getName());
        }
        roleTO.setPasswordPolicy(role.getPasswordPolicy() != null ? role.getPasswordPolicy().getId() : null);
        roleTO.setAccountPolicy(role.getAccountPolicy() != null ? role.getAccountPolicy().getId() : null);
        return roleTO;
    }
}

