/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.commons.lang.SerializationUtils;
import org.apache.syncope.client.to.ResourceTO;
import org.apache.syncope.client.to.SchemaMappingTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.rest.data.ConnInstanceDataBinder;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.IntMappingType;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ResourceDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDataBinder.class);
    private static final String[] MAPPING_IGNORE_PROPERTIES = new String[]{"id", "resource", "syncToken"};
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private JexlUtil jexlUtil;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private ConnInstanceDataBinder connInstancebinder;

    public ExternalResource create(ResourceTO resourceTO) throws SyncopeClientCompositeErrorException {
        return this.update(new ExternalResource(), resourceTO);
    }

    public ExternalResource update(ExternalResource resource, ResourceTO resourceTO) throws SyncopeClientCompositeErrorException {
        if (resourceTO == null) {
            return null;
        }
        resource.setName(resourceTO.getName());
        if (resourceTO.getConnectorId() != null) {
            ConnInstance connector = this.connInstanceDAO.find(resourceTO.getConnectorId());
            resource.setConnector(connector);
            if (!connector.getResources().contains(resource)) {
                connector.addResource(resource);
            }
        }
        resource.setForceMandatoryConstraint(resourceTO.isForceMandatoryConstraint());
        resource.setPropagationPrimary(resourceTO.isPropagationPrimary());
        resource.setPropagationPriority(resourceTO.getPropagationPriority());
        resource.setPropagationMode(resourceTO.getPropagationMode());
        resource.setMappings(this.getSchemaMappings(resource, resourceTO.getMappings()));
        resource.setAccountLink(resourceTO.getAccountLink());
        resource.setCreateTraceLevel(resourceTO.getCreateTraceLevel());
        resource.setUpdateTraceLevel(resourceTO.getUpdateTraceLevel());
        resource.setDeleteTraceLevel(resourceTO.getDeleteTraceLevel());
        resource.setSyncTraceLevel(resourceTO.getSyncTraceLevel());
        resource.setPasswordPolicy(resourceTO.getPasswordPolicy() != null ? (PasswordPolicy)this.policyDAO.find(resourceTO.getPasswordPolicy()) : null);
        resource.setAccountPolicy(resourceTO.getAccountPolicy() != null ? (AccountPolicy)this.policyDAO.find(resourceTO.getAccountPolicy()) : null);
        resource.setSyncPolicy(resourceTO.getSyncPolicy() != null ? (SyncPolicy)this.policyDAO.find(resourceTO.getSyncPolicy()) : null);
        resource.setConnectorConfigurationProperties(new HashSet<ConnConfProperty>(resourceTO.getConnConfProperties()));
        if (resourceTO.getSyncToken() == null) {
            resource.setSerializedSyncToken(null);
        }
        return resource;
    }

    public List<ResourceTO> getResourceTOs(Collection<ExternalResource> resources) {
        ArrayList<ResourceTO> resourceTOs = new ArrayList<ResourceTO>();
        for (ExternalResource resource : resources) {
            resourceTOs.add(this.getResourceTO(resource));
        }
        return resourceTOs;
    }

    public ResourceTO getResourceTO(ExternalResource resource) {
        if (resource == null) {
            return null;
        }
        ResourceTO resourceTO = new ResourceTO();
        resourceTO.setName(resource.getName());
        ConnInstance connector = resource.getConnector();
        resourceTO.setConnectorId(connector != null ? connector.getId() : null);
        resourceTO.setMappings(this.getSchemaMappingTOs(resource.getMappings()));
        resourceTO.setAccountLink(resource.getAccountLink());
        resourceTO.setForceMandatoryConstraint(resource.isForceMandatoryConstraint());
        resourceTO.setPropagationPrimary(resource.isPropagationPrimary());
        resourceTO.setPropagationPriority(resource.getPropagationPriority().intValue());
        resourceTO.setPropagationMode(resource.getPropagationMode());
        resourceTO.setCreateTraceLevel(resource.getCreateTraceLevel());
        resourceTO.setUpdateTraceLevel(resource.getUpdateTraceLevel());
        resourceTO.setDeleteTraceLevel(resource.getDeleteTraceLevel());
        resourceTO.setSyncTraceLevel(resource.getSyncTraceLevel());
        resourceTO.setPasswordPolicy(resource.getPasswordPolicy() != null ? resource.getPasswordPolicy().getId() : null);
        resourceTO.setAccountPolicy(resource.getAccountPolicy() != null ? resource.getAccountPolicy().getId() : null);
        resourceTO.setSyncPolicy(resource.getSyncPolicy() != null ? resource.getSyncPolicy().getId() : null);
        resourceTO.setConnectorConfigurationProperties(resource.getConfiguration());
        resourceTO.setSyncToken(resource.getSerializedSyncToken());
        return resourceTO;
    }

    private Set<SchemaMapping> getSchemaMappings(ExternalResource resource, List<SchemaMappingTO> mappings) {
        if (mappings == null) {
            return null;
        }
        HashSet<SchemaMapping> schemaMappings = new HashSet<SchemaMapping>();
        for (SchemaMappingTO mapping : mappings) {
            SchemaMapping schemaMapping = this.getSchemaMapping(resource, mapping);
            if (schemaMapping == null) continue;
            schemaMappings.add(schemaMapping);
        }
        return schemaMappings;
    }

    private SchemaMapping getSchemaMapping(ExternalResource resource, SchemaMappingTO mappingTO) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException compositeErrorException = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException requiredValuesMissing = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
        if (mappingTO == null || mappingTO.getIntMappingType() == null) {
            LOG.error("Null mappingTO provided");
            return null;
        }
        if (mappingTO.getIntAttrName() == null) {
            switch (mappingTO.getIntMappingType()) {
                case SyncopeUserId: {
                    mappingTO.setIntAttrName(IntMappingType.SyncopeUserId.toString());
                    break;
                }
                case Password: {
                    mappingTO.setIntAttrName(IntMappingType.Password.toString());
                    break;
                }
                case Username: {
                    mappingTO.setIntAttrName(IntMappingType.Username.toString());
                    break;
                }
                default: {
                    requiredValuesMissing.addElement("intAttrName");
                }
            }
        }
        if (!requiredValuesMissing.isEmpty()) {
            compositeErrorException.addException(requiredValuesMissing);
        }
        if (!this.jexlUtil.isExpressionValid(mappingTO.getMandatoryCondition() != null ? mappingTO.getMandatoryCondition() : "false")) {
            SyncopeClientException invalidMandatoryCondition = new SyncopeClientException(SyncopeClientExceptionType.InvalidValues);
            invalidMandatoryCondition.addElement(mappingTO.getMandatoryCondition());
            compositeErrorException.addException(invalidMandatoryCondition);
        }
        if (compositeErrorException.hasExceptions()) {
            throw compositeErrorException;
        }
        SchemaMapping mapping = new SchemaMapping();
        BeanUtils.copyProperties((Object)mappingTO, (Object)mapping, (String[])MAPPING_IGNORE_PROPERTIES);
        mapping.setResource(resource);
        return mapping;
    }

    public List<SchemaMappingTO> getSchemaMappingTOs(Collection<SchemaMapping> mappings) {
        if (mappings == null) {
            LOG.error("No mapping provided.");
            return null;
        }
        ArrayList<SchemaMappingTO> schemaMappingTOs = new ArrayList<SchemaMappingTO>();
        for (SchemaMapping mapping : mappings) {
            LOG.debug("Asking for TO for {}", (Object)mapping);
            schemaMappingTOs.add(this.getSchemaMappingTO(mapping));
        }
        LOG.debug("Collected TOs: {}", schemaMappingTOs);
        return schemaMappingTOs;
    }

    public SchemaMappingTO getSchemaMappingTO(SchemaMapping schemaMapping) {
        if (schemaMapping == null) {
            LOG.error("Provided null mapping");
            return null;
        }
        SchemaMappingTO schemaMappingTO = new SchemaMappingTO();
        BeanUtils.copyProperties((Object)schemaMapping, (Object)schemaMappingTO, (String[])MAPPING_IGNORE_PROPERTIES);
        schemaMappingTO.setId(schemaMapping.getId());
        LOG.debug("Obtained SchemaMappingTO {}", (Object)schemaMappingTO);
        return schemaMappingTO;
    }

    public ConnInstance getConnInstance(ExternalResource resource) throws NotFoundException {
        ConnInstance connInstanceClone = (ConnInstance)SerializationUtils.clone((Serializable)resource.getConnector());
        return this.getConnInstance(connInstanceClone, resource.getConfiguration());
    }

    public ConnInstance getConnInstance(ResourceTO resourceTO) throws NotFoundException {
        ConnInstance connInstance = this.connInstanceDAO.find(resourceTO.getConnectorId());
        ConnInstance connInstanceClone = (ConnInstance)SerializationUtils.clone((Serializable)connInstance);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + resourceTO.getConnectorId() + "'");
        }
        return this.getConnInstance(connInstanceClone, resourceTO.getConnConfProperties());
    }

    private ConnInstance getConnInstance(ConnInstance connInstance, Set<ConnConfProperty> overridden) throws NotFoundException {
        HashSet<ConnConfProperty> configuration = new HashSet<ConnConfProperty>();
        HashMap<String, ConnConfProperty> overridable = new HashMap<String, ConnConfProperty>();
        for (ConnConfProperty prop : connInstance.getConfiguration()) {
            if (prop.isOverridable()) {
                overridable.put(prop.getSchema().getName(), prop);
                continue;
            }
            configuration.add(prop);
        }
        for (ConnConfProperty prop : overridden) {
            if (!overridable.containsKey(prop.getSchema().getName()) || prop.getValues().isEmpty()) continue;
            configuration.add(prop);
            overridable.remove(prop.getSchema().getName());
        }
        configuration.addAll(overridable.values());
        connInstance.setConfiguration(configuration);
        return connInstance;
    }
}

